/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.FileCollection;

public final class DependencyDownloader {
    private final Project project;
    private final List<DependencyEntry> dependencies = new ArrayList<DependencyEntry>();
    private final Map<Attribute<?>, Object> attributes = new HashMap();

    public DependencyDownloader(Project project) {
        this.project = project;
    }

    public DependencyDownloader add(String dependencyNotation) {
        this.dependencies.add(new DependencyEntry.Notation(dependencyNotation));
        return this;
    }

    public DependencyDownloader platform(String dependencyNotation) {
        this.dependencies.add(new DependencyEntry.Platform(dependencyNotation));
        return this;
    }

    public DependencyDownloader addAll(Configuration configuration) {
        configuration.getAllDependencies().stream().map(DependencyEntry.Direct::new).forEach(this.dependencies::add);
        return this;
    }

    public <T> DependencyDownloader attribute(Attribute<T> attribute, T value) {
        this.attributes.put(attribute, value);
        return this;
    }

    public <T extends Named> DependencyDownloader attribute(Attribute<T> attribute, String name) {
        Named value = this.project.getObjects().named(attribute.getType(), name);
        return this.attribute(attribute, value);
    }

    public FileCollection download() {
        return this.download(true, false);
    }

    public FileCollection download(boolean transitive, boolean resolve) {
        Dependency[] dependencies = (Dependency[])this.dependencies.stream().map(entry -> entry.getDependency(this.project.getDependencies(), transitive)).toArray(Dependency[]::new);
        Configuration config = this.project.getConfigurations().detachedConfiguration(dependencies);
        config.setTransitive(transitive);
        config.attributes(attributes -> this.attributes.forEach((attribute, value) -> attributes.attribute(attribute, value)));
        return resolve ? this.project.files(new Object[]{config.resolve()}) : config;
    }

    public static FileCollection download(Project project, String dependencyNotation) {
        return new DependencyDownloader(project).add(dependencyNotation).download();
    }

    public static FileCollection download(Project project, String dependencyNotation, boolean transitive, boolean resolve) {
        return new DependencyDownloader(project).add(dependencyNotation).download(transitive, resolve);
    }

    public static Set<File> resolveFiles(Project project, Configuration configuration, boolean transitive) {
        return new DependencyDownloader(project).addAll(configuration).download(true, false).getFiles();
    }

    private static sealed interface DependencyEntry {
        public Dependency getDependency(DependencyHandler var1, boolean var2);

        public record Direct(Dependency dependency) implements DependencyEntry
        {
            @Override
            public Dependency getDependency(DependencyHandler dependencies, boolean transitive) {
                return this.dependency;
            }
        }

        public record Platform(String notation) implements DependencyEntry
        {
            @Override
            public Dependency getDependency(DependencyHandler dependencies, boolean transitive) {
                return dependencies.platform((Object)this.notation);
            }
        }

        public record Notation(String notation) implements DependencyEntry
        {
            @Override
            public Dependency getDependency(DependencyHandler dependencies, boolean transitive) {
                Dependency dependency = dependencies.create((Object)this.notation);
                if (dependency instanceof ModuleDependency) {
                    ModuleDependency md = (ModuleDependency)dependency;
                    md.setTransitive(transitive);
                }
                return dependency;
            }
        }
    }
}

