/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge;

import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.forge.MappingsMigrator;
import net.fabricmc.loom.configuration.providers.forge.MinecraftPatchedProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.ThreadingUtils;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Project;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

public final class FieldMappingsMigrator
implements MappingsMigrator {
    private List<Map.Entry<FieldMember, String>> migratedFields = new ArrayList<Map.Entry<FieldMember, String>>();
    public Path migratedFieldsCache;

    @Override
    public long setup(Project project, MinecraftProvider minecraftProvider, Path cache, Path rawMappings, boolean hasSrg, boolean hasMojang) throws IOException {
        this.migratedFieldsCache = cache.resolve("migrated-fields.json");
        this.migratedFields.clear();
        if (!minecraftProvider.refreshDeps() && Files.exists(this.migratedFieldsCache, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.migratedFieldsCache);){
                Map map = (Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, String>>(){}.getType());
                this.migratedFields = new ArrayList<Map.Entry<FieldMember, String>>();
                map.forEach((key, newDescriptor) -> {
                    String[] split = key.split("#");
                    this.migratedFields.add(new AbstractMap.SimpleEntry<FieldMember, String>(new FieldMember(split[0], split[1]), (String)newDescriptor));
                });
            }
        } else {
            Files.deleteIfExists(this.migratedFieldsCache);
            this.migratedFields.clear();
            if (hasSrg) {
                this.migratedFields.addAll(FieldMappingsMigrator.generateNewFieldMigration(project, MinecraftPatchedProvider.get(project).getMinecraftPatchedIntermediateJar(), MappingsNamespace.SRG.toString(), rawMappings).entrySet());
            } else if (hasMojang) {
                this.migratedFields.addAll(FieldMappingsMigrator.generateNewFieldMigration(project, MinecraftPatchedProvider.get(project).getMinecraftPatchedIntermediateJar(), MappingsNamespace.MOJANG.toString(), rawMappings).entrySet());
            }
            HashMap map = new HashMap();
            this.migratedFields.forEach(entry -> map.put(((FieldMember)entry.getKey()).owner + "#" + ((FieldMember)entry.getKey()).field, (String)entry.getValue()));
            Files.writeString(this.migratedFieldsCache, (CharSequence)new Gson().toJson(map), new OpenOption[0]);
        }
        this.migratedFields.sort(Comparator.comparing(entry -> ((FieldMember)entry.getKey()).owner + "#" + ((FieldMember)entry.getKey()).field));
        return this.migratedFields.hashCode();
    }

    @Override
    public void migrate(Project project, List<MappingsMigrator.MappingsEntry> entries) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        try {
            this.updateFieldMigration(project, entries);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        project.getLogger().info(":migrated {} fields in " + String.valueOf(stopwatch.stop()), (Object)((ModPlatform)((Object)extension.getPlatform().get())).id());
    }

    public void updateFieldMigration(Project project, List<MappingsMigrator.MappingsEntry> entries) throws IOException {
        HashBasedTable fieldDescriptorMap = HashBasedTable.create();
        for (Map.Entry<FieldMember, String> entry : this.migratedFields) {
            fieldDescriptorMap.put((Object)entry.getKey().owner, (Object)entry.getKey().field, (Object)entry.getValue());
        }
        for (MappingsMigrator.MappingsEntry mappingsEntry : entries) {
            FieldMappingsMigrator.injectMigration(project, (Table<String, String, String>)fieldDescriptorMap, mappingsEntry.path());
        }
    }

    private static void injectMigration(Project project, Table<String, String, String> fieldDescriptorMap, Path path) throws IOException {
        MemoryMappingTree mappings = new MemoryMappingTree();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            MappingReader.read((Reader)reader, (MappingVisitor)mappings);
        }
        for (MappingTree.ClassMapping classDef : new ArrayList(mappings.getClasses())) {
            Map row = fieldDescriptorMap.row((Object)classDef.getName(MappingsNamespace.INTERMEDIARY.toString()));
            if (row.isEmpty()) continue;
            for (MappingTree.FieldMapping fieldDef : new ArrayList(classDef.getFields())) {
                String newDescriptor = (String)row.get(fieldDef.getName(MappingsNamespace.INTERMEDIARY.toString()));
                if (newDescriptor == null) continue;
                String prev = fieldDef.getDesc(MappingsNamespace.INTERMEDIARY.toString());
                fieldDef.setSrcDesc(mappings.mapDesc((CharSequence)newDescriptor, mappings.getNamespaceId(MappingsNamespace.INTERMEDIARY.toString()), -1));
                project.getLogger().info("Migrated field descriptor of field {}#{} from {} to {}", new Object[]{classDef.getName(MappingsNamespace.INTERMEDIARY.toString()), fieldDef.getName(MappingsNamespace.INTERMEDIARY.toString()), prev, newDescriptor});
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            mappings.accept((MappingVisitor)new Tiny2FileWriter((Writer)writer, false));
        }
    }

    private static Map<FieldMember, String> generateNewFieldMigration(Project project, Path patchedJar, String patchedJarNamespace, Path mappingsPath) throws IOException {
        final ConcurrentHashMap fieldDescriptorMap = new ConcurrentHashMap();
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ThreadingUtils.TaskCompleter completer = ThreadingUtils.taskCompleter();
        class Visitor
        extends ClassVisitor {
            private final ThreadLocal<String> lastClass;

            Visitor(int api) {
                super(api);
                this.lastClass = new ThreadLocal();
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.lastClass.set(name);
            }

            public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                fieldDescriptorMap.put(new FieldMember(this.lastClass.get(), name), descriptor);
                return super.visitField(access, name, descriptor, signature, value);
            }
        }
        Visitor visitor = new Visitor(589824);
        FileSystemUtil.Delegate system = FileSystemUtil.getJarFileSystem(patchedJar, false);
        completer.onComplete(value -> system.close());
        for (Path fsPath : Files.walk(system.get().getPath("/", new String[0]), new FileVisitOption[0])::iterator) {
            if (!Files.isRegularFile(fsPath, new LinkOption[0]) || !fsPath.toString().endsWith(".class")) continue;
            completer.add(() -> {
                byte[] bytes = Files.readAllBytes(fsPath);
                new ClassReader(bytes).accept((ClassVisitor)visitor, 7);
            });
        }
        completer.complete();
        HashMap<FieldMember, String> migratedFields = new HashMap<FieldMember, String>();
        try (BufferedReader reader = Files.newBufferedReader(mappingsPath);){
            MemoryMappingTree mappings = new MemoryMappingTree();
            MappingReader.read((Reader)reader, (MappingVisitor)mappings);
            for (MappingTree.ClassMapping classDef : mappings.getClasses()) {
                for (MappingTree.FieldMapping fieldDef : classDef.getFields()) {
                    String newDescriptor = (String)fieldDescriptorMap.get(new FieldMember(classDef.getName(patchedJarNamespace), fieldDef.getName(patchedJarNamespace)));
                    String existingDescriptor = fieldDef.getDesc(patchedJarNamespace);
                    if (newDescriptor == null || newDescriptor.equals(existingDescriptor)) continue;
                    String ownerIntermediary = classDef.getName(MappingsNamespace.INTERMEDIARY.toString());
                    String fieldIntermediary = fieldDef.getName(MappingsNamespace.INTERMEDIARY.toString());
                    String descriptorIntermediary = fieldDef.getDesc(MappingsNamespace.INTERMEDIARY.toString());
                    String newDescriptorIntermediary = mappings.mapDesc((CharSequence)newDescriptor, mappings.getNamespaceId(patchedJarNamespace), mappings.getNamespaceId(MappingsNamespace.INTERMEDIARY.toString()));
                    migratedFields.put(new FieldMember(ownerIntermediary, fieldIntermediary), newDescriptorIntermediary);
                    project.getLogger().info("Found migration of " + ownerIntermediary + "#" + fieldIntermediary + ": " + descriptorIntermediary + " -> " + newDescriptorIntermediary);
                }
            }
        }
        return migratedFields;
    }

    public static class FieldMember {
        public String owner;
        public String field;

        public FieldMember(String owner, String field) {
            this.owner = owner;
            this.field = field;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldMember that = (FieldMember)o;
            return Objects.equals(this.owner, that.owner) && Objects.equals(this.field, that.field);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.field);
        }
    }
}

