/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerEntry;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.LazyCloseable;
import net.fabricmc.loom.util.fmj.ModEnvironment;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.jetbrains.annotations.Nullable;

public record LocalAccessWidenerEntry(Path path, String hash) implements AccessWidenerEntry
{
    public static LocalAccessWidenerEntry create(Path path) {
        return new LocalAccessWidenerEntry(path, Checksum.of(path).sha1().hex());
    }

    @Override
    public void read(AccessWidenerVisitor visitor, LazyCloseable<TinyRemapper> remapper) throws IOException {
        AccessWidenerReader reader = new AccessWidenerReader(visitor);
        reader.read(Files.readAllBytes(this.path));
    }

    @Override
    public ModEnvironment environment() {
        return ModEnvironment.UNIVERSAL;
    }

    @Override
    @Nullable
    public String mappingId() {
        return null;
    }

    @Override
    public String getSortKey() {
        return "local";
    }

    @Override
    public int hashCode() {
        return this.hash.hashCode();
    }
}

