/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.PatchOperation;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.PatchMode;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import net.fabricmc.loom.configuration.providers.forge.ConfigValue;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.StepLogic;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.Provider;

public final class PatchLogic
extends StepLogic<Service.Options> {
    public static final ServiceType<Service.Options, PatchLogic> TYPE = new ServiceType<Service.Options, PatchLogic>(Service.Options.class, PatchLogic.class);

    public static Provider<Service.Options> createOptions(StepLogic.SetupContext context) {
        return TYPE.create(context.project(), (Action<Service.Options>)((Action)options -> {}));
    }

    public PatchLogic(Service.Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    @Override
    public void execute(StepLogic.ExecutionContext context) throws IOException {
        Path input = Path.of(context.resolve(new ConfigValue.Variable("input")), new String[0]);
        Path patches = Path.of(context.resolve(new ConfigValue.Variable("patches")), new String[0]);
        Path output = context.setOutput("output.jar");
        Path rejects = context.cache().resolve("rejects");
        CliOperation.Result result = PatchOperation.builder().logTo((OutputStream)new LoggingOutputStream(context.logger(), LogLevel.INFO)).basePath(input).patchesPath(patches).outputPath(output).mode(PatchMode.OFFSET).rejectsPath(rejects).build().operate();
        if (result.exit != 0) {
            throw new RuntimeException("Could not patch " + String.valueOf(input) + "; rejects saved to " + String.valueOf(rejects.toAbsolutePath()));
        }
    }
}

