/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.metadata;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlParser;
import com.google.common.collect.ImmutableSet;
import dev.architectury.loom.metadata.ModMetadataFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loom.configuration.ifaceinject.InterfaceInjectionProcessor;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.ModPlatform;
import org.jetbrains.annotations.Nullable;

public final class ModsToml
implements ModMetadataFile {
    public static final String FILE_PATH = "META-INF/mods.toml";
    public static final String NEOFORGE_FILE_PATH = "META-INF/neoforge.mods.toml";
    private final Config config;

    private ModsToml(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public static ModsToml of(byte[] utf8) {
        return ModsToml.of(new String(utf8, StandardCharsets.UTF_8));
    }

    public static ModsToml of(String text) {
        try {
            return new ModsToml(new TomlParser().parse(text));
        }
        catch (ParsingException e) {
            throw ExceptionUtil.createDescriptiveWrapper(IllegalArgumentException::new, "Could not parse mods.toml", e);
        }
    }

    public static ModsToml of(Path path) throws IOException {
        ModsToml modsToml;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
            try {
                modsToml = new ModsToml((Config)new TomlParser().parse((Reader)reader));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParsingException e) {
                    throw ExceptionUtil.createDescriptiveWrapper(IllegalArgumentException::new, "Could not parse mods.toml", e);
                }
            }
            reader.close();
        }
        return modsToml;
    }

    public static ModsToml of(File file) throws IOException {
        return ModsToml.of(file.toPath());
    }

    @Override
    public Set<String> getIds() {
        Optional mods = this.config.getOptional("mods");
        if (mods.isEmpty()) {
            return Set.of();
        }
        ImmutableSet.Builder modIds = ImmutableSet.builder();
        for (Config mod : (List)mods.get()) {
            Optional modId = mod.getOptional("modId");
            modId.ifPresent(arg_0 -> ((ImmutableSet.Builder)modIds).add(arg_0));
        }
        return modIds.build();
    }

    @Override
    public Set<String> getAccessWideners() {
        return Set.of();
    }

    @Override
    public Set<String> getAccessTransformers(ModPlatform platform) {
        List ats;
        if (platform == ModPlatform.NEOFORGE && (ats = (List)this.config.get("accessTransformers")) != null) {
            HashSet<String> result = new HashSet<String>();
            for (Config atEntry : ats) {
                String file = (String)atEntry.get("file");
                if (file == null) continue;
                result.add(file);
            }
            return result;
        }
        return Set.of();
    }

    @Override
    public List<InterfaceInjectionProcessor.InjectedInterface> getInjectedInterfaces(@Nullable String modId) {
        return List.of();
    }

    @Override
    public String getFileName() {
        return FILE_PATH;
    }

    @Override
    public List<String> getMixinConfigs() {
        return List.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ModsToml)) return false;
        ModsToml modsToml = (ModsToml)obj;
        if (!modsToml.config.equals((Object)this.config)) return false;
        return true;
    }

    public int hashCode() {
        return this.config.hashCode();
    }
}

