/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.api.mappings.layered.MappingLayer;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.providers.mappings.GradleMappingContext;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingSpec;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingsProcessor;
import net.fabricmc.loom.configuration.providers.mappings.NoOpIntermediateMappingsProvider;
import net.fabricmc.loom.configuration.providers.mappings.extras.unpick.UnpickLayer;
import net.fabricmc.loom.configuration.providers.mappings.utils.AddConstructorMappingVisitor;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingDstNsReorder;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record LayeredMappingsFactory(LayeredMappingSpec spec) {
    private static final String GROUP = "loom";
    private static final String MODULE = "mappings";
    private static final Logger LOGGER = LoggerFactory.getLogger(LayeredMappingsFactory.class);

    public static void afterEvaluate(ConfigContext configContext) {
        for (LayeredMappingsFactory layeredMappingFactory : configContext.extension().getLayeredMappingFactories()) {
            try {
                layeredMappingFactory.evaluate(configContext);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to setup layered mappings: %s".formatted(layeredMappingFactory.mavenNotation()), e);
            }
        }
    }

    private void evaluate(ConfigContext configContext) throws IOException {
        LOGGER.info("Evaluating layer mapping: {}", (Object)this.mavenNotation());
        Path mavenRepoDir = configContext.extension().getFiles().getGlobalMinecraftRepo().toPath();
        LocalMavenHelper maven = new LocalMavenHelper(GROUP, MODULE, this.spec().getVersion(), null, mavenRepoDir);
        Path jar = this.resolve(configContext.project());
        maven.copyToMaven(jar, null);
    }

    public Path resolve(Project project) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        GradleMappingContext mappingContext = new GradleMappingContext(project, this.spec.getVersion().replace("+", "_").replace(".", "_"));
        Path mappingsDir = mappingContext.minecraftProvider().dir("layered").toPath();
        Path mappingsZip = mappingsDir.resolve(String.format("%s.%s-%s.jar", GROUP, MODULE, this.spec.getVersion()));
        if (Files.exists(mappingsZip, new LinkOption[0]) && !mappingContext.refreshDeps()) {
            return mappingsZip;
        }
        boolean noIntermediateMappings = extension.getIntermediateMappingsProvider() instanceof NoOpIntermediateMappingsProvider;
        LayeredMappingsProcessor processor = new LayeredMappingsProcessor(this.spec, noIntermediateMappings);
        List<MappingLayer> layers = processor.resolveLayers(mappingContext);
        Files.deleteIfExists(mappingsZip);
        this.writeMapping(processor, layers, mappingsZip);
        this.writeSignatureFixes(processor, layers, mappingsZip);
        this.writeUnpickData(processor, layers, mappingsZip);
        return mappingsZip;
    }

    public Dependency createDependency(Project project) {
        return project.getDependencies().create((Object)this.mavenNotation());
    }

    public String mavenNotation() {
        return String.format("%s:%s:%s", GROUP, MODULE, this.spec.getVersion());
    }

    private void writeMapping(LayeredMappingsProcessor processor, List<MappingLayer> layers, Path mappingsFile) throws IOException {
        MemoryMappingTree mappings = processor.getMappings(layers);
        try (StringWriter writer = new StringWriter();){
            Tiny2FileWriter tiny2Writer = new Tiny2FileWriter((Writer)writer, false);
            MappingDstNsReorder nsReorder = new MappingDstNsReorder((MappingVisitor)tiny2Writer, List.of(MappingsNamespace.NAMED.toString(), MappingsNamespace.OFFICIAL.toString()));
            MappingSourceNsSwitch nsSwitch = new MappingSourceNsSwitch((MappingVisitor)nsReorder, MappingsNamespace.INTERMEDIARY.toString(), true);
            AddConstructorMappingVisitor addConstructor = new AddConstructorMappingVisitor((MappingVisitor)nsSwitch);
            mappings.accept((MappingVisitor)addConstructor);
            Files.deleteIfExists(mappingsFile);
            ZipUtils.add(mappingsFile, "mappings/mappings.tiny", ((Object)writer).toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private void writeSignatureFixes(LayeredMappingsProcessor processor, List<MappingLayer> layers, Path mappingsFile) throws IOException {
        Map<String, String> signatureFixes = processor.getSignatureFixes(layers);
        if (signatureFixes == null) {
            return;
        }
        byte[] data = LoomGradlePlugin.GSON.toJson(signatureFixes).getBytes(StandardCharsets.UTF_8);
        ZipUtils.add(mappingsFile, "extras/record_signatures.json", data);
    }

    private void writeUnpickData(LayeredMappingsProcessor processor, List<MappingLayer> layers, Path mappingsFile) throws IOException {
        UnpickLayer.UnpickData unpickData = processor.getUnpickData(layers);
        if (unpickData == null) {
            return;
        }
        ZipUtils.add(mappingsFile, "extras/definitions.unpick", unpickData.definitions());
        ZipUtils.add(mappingsFile, "extras/unpick.json", unpickData.rawMetadata());
    }
}

