/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.build;

import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.util.ModPlatform;
import org.gradle.api.Project;

public final class IntermediaryNamespaces {
    public static String intermediary(Project project) {
        return IntermediaryNamespaces.intermediaryNamespace(project).toString();
    }

    public static String runtimeIntermediary(Project project) {
        return IntermediaryNamespaces.runtimeIntermediaryNamespace(project).toString();
    }

    public static MappingsNamespace intermediaryNamespace(Project project) {
        return IntermediaryNamespaces.intermediaryNamespace((ModPlatform)((Object)LoomGradleExtension.get(project).getPlatform().get()));
    }

    public static MappingsNamespace intermediaryNamespace(ModPlatform platform) {
        return switch (platform) {
            default -> throw new MatchException(null, null);
            case ModPlatform.FABRIC, ModPlatform.QUILT -> MappingsNamespace.INTERMEDIARY;
            case ModPlatform.FORGE -> MappingsNamespace.SRG;
            case ModPlatform.NEOFORGE -> MappingsNamespace.MOJANG;
        };
    }

    public static MappingsNamespace runtimeIntermediaryNamespace(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.isForge() && extension.getForgeProvider().usesMojangAtRuntime()) {
            return MappingsNamespace.MOJANG;
        }
        return IntermediaryNamespaces.intermediaryNamespace(project);
    }

    public static String replaceMixinIntermediaryNamespace(Project project, String namespace) {
        return namespace.equals(IntermediaryNamespaces.runtimeIntermediary(project)) ? MappingsNamespace.INTERMEDIARY.toString() : namespace;
    }
}

