/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge;

import java.io.File;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.forge.DependencyProvider;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;

public class ForgeUniversalProvider
extends DependencyProvider {
    private File forge;

    public ForgeUniversalProvider(Project project) {
        super(project);
    }

    @Override
    public void provide(DependencyInfo dependency) throws Exception {
        this.forge = new File(this.getExtension().getForgeProvider().getGlobalCache(), "forge-universal.jar");
        if (!this.forge.exists() || this.refreshDeps()) {
            File dep = dependency.resolveFile().orElseThrow(() -> new RuntimeException("Could not resolve Forge"));
            FileUtils.copyFile((File)dep, (File)this.forge);
        }
    }

    public File getForge() {
        return this.forge;
    }

    @Override
    public String getTargetConfig() {
        return "forgeUniversal";
    }
}

