/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.build.nesting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.ZipReprocessorUtil;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import org.apache.commons.io.FileUtils;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NestableJarGenerationTask
extends AbstractLoomTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(NestableJarGenerationTask.class);
    private static final String SEMVER_REGEX = "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$";
    private static final Pattern SEMVER_PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    public static final String NESTING_METADATA_PATH = "META-INF/architectury-loom-nesting-metadata.json";

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    protected abstract ConfigurableFileCollection getJars();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Input
    protected abstract MapProperty<String, Metadata> getJarIds();

    @Inject
    public NestableJarGenerationTask() {
    }

    @TaskAction
    void makeNestableJars() {
        ModPlatform platform = (ModPlatform)((Object)this.getModPlatform().get());
        HashMap fabricModJsons = new HashMap();
        HashMap metadataFiles = new HashMap();
        ((Map)this.getJarIds().get()).forEach((fileName, metadata) -> {
            if (platform.isForgeLike()) {
                metadataFiles.put(fileName, LoomGradlePlugin.GSON.toJson(metadata));
                return;
            }
            fabricModJsons.put(fileName, NestableJarGenerationTask.generateModForDependency(metadata));
        });
        try {
            File targetDir = ((Directory)this.getOutputDirectory().get()).getAsFile();
            FileUtils.deleteDirectory((File)targetDir);
            targetDir.mkdirs();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.getJars().forEach(file -> {
            File targetFile = ((RegularFile)this.getOutputDirectory().file(file.getName()).get()).getAsFile();
            targetFile.delete();
            String fabricModJson = (String)fabricModJsons.get(file.getName());
            String nestingMetadata = (String)metadataFiles.get(file.getName());
            if (platform.isForgeLike()) {
                Objects.requireNonNull(nestingMetadata, "Could not generate nesting metadata for included dependency " + file.getName());
            } else {
                Objects.requireNonNull(fabricModJson, "Could not generate fabric.mod.json for included dependency " + file.getName());
            }
            this.makeNestableJar((File)file, targetFile, fabricModJson, nestingMetadata);
        });
    }

    public void from(Configuration configuration) {
        ArtifactView artifacts = configuration.getIncoming().artifactView(config -> config.attributes(attr -> attr.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar")));
        this.getJars().from(new Object[]{artifacts.getFiles()});
        this.dependsOn(new Object[]{configuration});
        this.getJarIds().set(artifacts.getArtifacts().getResolvedArtifacts().map(set -> {
            HashMap map = new HashMap();
            set.forEach(artifact -> {
                String rest;
                int dotIndex;
                List<Metadata> capabilityLocations;
                ResolvedVariantResult variant = artifact.getVariant();
                ComponentIdentifier id = variant.getOwner();
                Metadata moduleLocation = null;
                if (id instanceof ModuleComponentIdentifier) {
                    ModuleComponentIdentifier moduleIdentifier = (ModuleComponentIdentifier)id;
                    moduleLocation = new Metadata(moduleIdentifier.getGroup(), moduleIdentifier.getModule(), moduleIdentifier.getVersion(), null);
                }
                if (!((capabilityLocations = variant.getCapabilities().stream().map(capability -> new Metadata(capability.getGroup(), capability.getName(), capability.getVersion(), null)).toList()).isEmpty() || moduleLocation != null && capabilityLocations.contains(moduleLocation))) {
                    moduleLocation = capabilityLocations.get(0);
                }
                if (moduleLocation == null) {
                    throw new RuntimeException("Attempted to nest artifact " + String.valueOf(id) + " which is not a module component and has no capabilities.");
                }
                if (moduleLocation.version == null) {
                    throw new RuntimeException("Attempted to nest artifact " + String.valueOf(id) + " which has no version");
                }
                String group = moduleLocation.group;
                String name = moduleLocation.name;
                String version = moduleLocation.version;
                String classifier = null;
                if (artifact.getFile().getName().startsWith(name + "-" + version + "-") && (dotIndex = (rest = artifact.getFile().getName().substring(name.length() + version.length() + 2)).indexOf(46)) != -1) {
                    classifier = rest.substring(0, dotIndex);
                }
                Metadata metadata = new Metadata(group, name, version, classifier);
                map.put(artifact.getFile().getName(), metadata);
            });
            return map;
        }));
    }

    private static String generateModForDependency(Metadata metadata) {
        Object modId = (metadata.group() + "_" + metadata.name() + metadata.classifier()).replaceAll("\\.", "_").toLowerCase(Locale.ENGLISH);
        if (((String)modId).length() > 64) {
            String hash = Checksum.of((String)modId).sha256().hex();
            modId = ((String)modId).substring(0, 50) + hash.substring(0, 14);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("schemaVersion", (Number)1);
        jsonObject.addProperty("id", (String)modId);
        String version = NestableJarGenerationTask.getVersion(metadata);
        jsonObject.addProperty("version", version);
        jsonObject.addProperty("name", metadata.name());
        JsonObject custom = new JsonObject();
        custom.addProperty("fabric-loom:generated", Boolean.valueOf(true));
        jsonObject.add("custom", (JsonElement)custom);
        return LoomGradlePlugin.GSON.toJson((JsonElement)jsonObject);
    }

    private static String getVersion(Metadata metadata) {
        String trimmedVersion;
        String version = metadata.version();
        if (NestableJarGenerationTask.validSemVer(version)) {
            return version;
        }
        if ((version.endsWith(".Final") || version.endsWith(".final")) && NestableJarGenerationTask.validSemVer(trimmedVersion = version.substring(0, version.length() - 6))) {
            return trimmedVersion;
        }
        LOGGER.warn("({}) is not valid semver for dependency {}", (Object)version, (Object)metadata);
        return version;
    }

    private static boolean validSemVer(String version) {
        Matcher matcher = SEMVER_PATTERN.matcher(version);
        return matcher.find();
    }

    private void makeNestableJar(File input, File output, @Nullable String modJsonFile, @Nullable String nestingMetadata) {
        try {
            FileUtils.copyFile((File)input, (File)output);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to copy mod file %s".formatted(input), e);
        }
        if (nestingMetadata != null) {
            try {
                ZipUtils.add(output.toPath(), NESTING_METADATA_PATH, nestingMetadata);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to add nesting metadata to " + String.valueOf(input), e);
            }
        }
        if (modJsonFile == null || FabricModJsonFactory.isModJar(input, (ModPlatform)((Object)this.getModPlatform().get()))) {
            return;
        }
        try {
            ZipReprocessorUtil.appendZipEntry(output.toPath(), "fabric.mod.json", modJsonFile.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to add dummy mod while including %s".formatted(input), e);
        }
    }

    public record Metadata(String group, String name, String version, @Nullable String classifier) implements Serializable
    {
        @Nullable
        private final String classifier;

        public String classifier() {
            if (this.classifier == null) {
                return "";
            }
            return "_" + this.classifier;
        }

        @Override
        public String toString() {
            return this.group + ":" + this.name + ":" + this.version + this.classifier();
        }
    }
}

