/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.fabricapi;

import java.io.File;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.util.download.DownloadException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class FabricApiVersions {
    private final HashMap<String, Map<String, String>> moduleVersionCache = new HashMap();
    private final HashMap<String, Map<String, String>> deprecatedModuleVersionCache = new HashMap();

    @Inject
    protected abstract Project getProject();

    public Dependency module(String moduleName, String fabricApiVersion) {
        return this.getProject().getDependencies().create((Object)this.getDependencyNotation(moduleName, fabricApiVersion));
    }

    public String moduleVersion(String moduleName, String fabricApiVersion) {
        String moduleVersion = (String)this.moduleVersionCache.computeIfAbsent(fabricApiVersion, this::getApiModuleVersions).get(moduleName);
        if (moduleVersion == null) {
            moduleVersion = (String)this.deprecatedModuleVersionCache.computeIfAbsent(fabricApiVersion, this::getDeprecatedApiModuleVersions).get(moduleName);
        }
        if (moduleVersion == null) {
            throw new RuntimeException("Failed to find module version for module: " + moduleName);
        }
        return moduleVersion;
    }

    private String getDependencyNotation(String moduleName, String fabricApiVersion) {
        return String.format("net.fabricmc.fabric-api:%s:%s", moduleName, this.moduleVersion(moduleName, fabricApiVersion));
    }

    private Map<String, String> getApiModuleVersions(String fabricApiVersion) {
        try {
            return this.populateModuleVersionMap(this.getApiMavenPom(fabricApiVersion));
        }
        catch (PomNotFoundException e) {
            throw new RuntimeException("Could not find fabric-api version: " + fabricApiVersion);
        }
    }

    private Map<String, String> getDeprecatedApiModuleVersions(String fabricApiVersion) {
        try {
            return this.populateModuleVersionMap(this.getDeprecatedApiMavenPom(fabricApiVersion));
        }
        catch (PomNotFoundException e) {
            return Collections.emptyMap();
        }
    }

    private Map<String, String> populateModuleVersionMap(File pomFile) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document pom = docBuilder.parse(pomFile);
            HashMap<String, String> versionMap = new HashMap<String, String>();
            NodeList dependencies = ((Element)pom.getElementsByTagName("dependencies").item(0)).getElementsByTagName("dependency");
            for (int i = 0; i < dependencies.getLength(); ++i) {
                Element dep = (Element)dependencies.item(i);
                Element artifact = (Element)dep.getElementsByTagName("artifactId").item(0);
                Element version = (Element)dep.getElementsByTagName("version").item(0);
                if (artifact == null || version == null) {
                    throw new RuntimeException("Failed to find artifact or version");
                }
                versionMap.put(artifact.getTextContent(), version.getTextContent());
            }
            return versionMap;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse " + pomFile.getName(), e);
        }
    }

    private File getApiMavenPom(String fabricApiVersion) throws PomNotFoundException {
        return this.getPom("fabric-api", fabricApiVersion);
    }

    private File getDeprecatedApiMavenPom(String fabricApiVersion) throws PomNotFoundException {
        return this.getPom("fabric-api-deprecated", fabricApiVersion);
    }

    private File getPom(String name, String version) throws PomNotFoundException {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        File mavenPom = new File(extension.getFiles().getUserCache(), "fabric-api/%s-%s.pom".formatted(name, version));
        try {
            extension.download(String.format("https://maven.fabricmc.net/net/fabricmc/fabric-api/%2$s/%1$s/%2$s-%1$s.pom", version, name)).defaultCache().downloadPath(mavenPom.toPath());
        }
        catch (DownloadException e) {
            if (e.getStatusCode() == 404) {
                throw new PomNotFoundException(e);
            }
            throw new UncheckedIOException("Failed to download maven info to " + mavenPom.getName(), e);
        }
        return mavenPom;
    }

    private static class PomNotFoundException
    extends Exception {
        PomNotFoundException(Throwable cause) {
            super(cause);
        }
    }
}

