/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.neoforge;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.mappingio.tree.MappingTreeView;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public final class StringConstantPatcher
extends ClassVisitor {
    private final Map<String, String> constantChanges;
    private static final String LAUNCH_HANDLER_INPUT_CLASS_FILE = "net/minecraft/client/Minecraft.class";
    private static final String LAUNCH_HANDLER_OUTPUT_CLASS_FILE = "net/minecraft/client/main/Main.class";
    private static final RemapKey DETECTED_VERSION_KEY = new RemapKey("net/minecraft/DetectedVersion.class", "net/minecraft/class_3797");
    private static final RemapKey MINECRAFT_KEY = new RemapKey("net/minecraft/client/Minecraft.class", "net/minecraft/class_310");

    private StringConstantPatcher(ClassVisitor next, Map<String, String> constantChanges) {
        super(589824, next);
        this.constantChanges = constantChanges;
    }

    private StringConstantPatcher(ClassVisitor next, String from, String to) {
        this(next, Map.of(from, to));
    }

    public static ClassVisitor forUserdevLaunchHandler(ClassVisitor next) {
        return new StringConstantPatcher(next, LAUNCH_HANDLER_INPUT_CLASS_FILE, LAUNCH_HANDLER_OUTPUT_CLASS_FILE);
    }

    private static ClassVisitor forRemapping(ClassVisitor next, MappingTreeView mappings, RemapKey ... keys) {
        HashMap<String, String> constantChanges = new HashMap<String, String>();
        for (RemapKey key : keys) {
            @Nullable String target = StringConstantPatcher.getNamedClassName(mappings, key.intermediary);
            if (target == null || key.constantWithClassSuffix.equals(target + ".class")) continue;
            constantChanges.put(key.constantWithClassSuffix, target + ".class");
        }
        if (!constantChanges.isEmpty()) {
            return new StringConstantPatcher(next, constantChanges);
        }
        return next;
    }

    @Nullable
    private static String getNamedClassName(MappingTreeView mappings, String intermediary) {
        int intermediaryNsId = mappings.getNamespaceId(MappingsNamespace.INTERMEDIARY.toString());
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable MappingTreeView.ClassMappingView c = mappings.getClass(intermediary, intermediaryNsId);
        return c != null ? c.getName(MappingsNamespace.NAMED.toString()) : null;
    }

    public static ClassVisitor forFmlLoader(ClassVisitor next, MappingTreeView mappings) {
        return StringConstantPatcher.forRemapping(next, mappings, DETECTED_VERSION_KEY);
    }

    public static ClassVisitor forGameLocator(ClassVisitor next, MappingTreeView mappings) {
        return StringConstantPatcher.forRemapping(next, mappings, MINECRAFT_KEY);
    }

    public static ClassVisitor forRequiredSystemFiles(ClassVisitor next, MappingTreeView mappings) {
        return StringConstantPatcher.forRemapping(next, mappings, DETECTED_VERSION_KEY, MINECRAFT_KEY);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return new MethodPatcher(super.visitMethod(access, name, descriptor, signature, exceptions));
    }

    private record RemapKey(String constantWithClassSuffix, String intermediary) {
    }

    private final class MethodPatcher
    extends MethodVisitor {
        MethodPatcher(MethodVisitor next) {
            super(589824, next);
        }

        public void visitLdcInsn(Object value) {
            String key;
            String target;
            if (value instanceof String && (target = StringConstantPatcher.this.constantChanges.get(key = (String)value)) != null) {
                value = target;
            }
            super.visitLdcInsn(value);
        }
    }
}

