/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.task.RunGameTask;
import net.fabricmc.loom.util.Platform;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RenderDocRunTask
extends RunGameTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderDocRunTask.class);

    @InputFile
    public abstract RegularFileProperty getRenderDocExecutable();

    @Input
    public abstract ListProperty<String> getRenderDocArgs();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Inject
    public RenderDocRunTask(RunConfigSettings settings) {
        super(settings);
        this.setGroup("loom");
        this.dependsOn(new Object[]{"configureClientLaunch"});
        this.getRenderDocArgs().addAll((Object[])new String[]{"capture", "--wait-for-exit"});
    }

    @Override
    public void exec() {
        ExecResult result = this.getExecOperations().exec(exec -> {
            exec.workingDir((Object)new File((String)this.getProjectDir().get(), (String)this.getInternalRunDir().get()));
            exec.environment((Map)this.getInternalEnvironmentVars().get());
            exec.commandLine(new Object[]{((RegularFile)this.getRenderDocExecutable().get()).getAsFile()});
            exec.args((Iterable)this.getRenderDocArgs().get());
            exec.args(new Object[]{"--working-dir", new File((String)this.getProjectDir().get(), (String)this.getInternalRunDir().get())});
            exec.args(new Object[]{((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath()});
            exec.args((Iterable)this.getJvmArgs());
            exec.args(new Object[]{this.getMainClass().get()});
            for (CommandLineArgumentProvider provider : this.getArgumentProviders()) {
                exec.args(provider.asArguments());
            }
            LOGGER.info("Running command: {}", (Object)exec.getCommandLine());
        });
        result.assertNormalExitValue();
    }

    public static boolean isSupported(Platform platform) {
        Platform.OperatingSystem os = platform.getOperatingSystem();
        Platform.Architecture arch = platform.getArchitecture();
        return (os.isLinux() || os.isWindows()) && arch.isX64();
    }
}

