/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.providers.forge.FieldMappingsMigrator;
import net.fabricmc.loom.configuration.providers.forge.ForgeProvider;
import net.fabricmc.loom.configuration.providers.forge.MappingsMigrator;
import net.fabricmc.loom.configuration.providers.forge.MethodInheritanceMappingsMigrator;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.util.ModPlatform;
import org.gradle.api.Project;

public final class ForgeMigratedMappingConfiguration
extends MappingConfiguration {
    private final List<MappingsMigrator> migrators = List.of(new FieldMappingsMigrator(), new MethodInheritanceMappingsMigrator());
    private Path hashPath;
    private Path rawTinyMappings;
    private Path rawTinyMappingsWithSrg;
    private Path rawTinyMappingsWithMojang;
    private long hash;

    public ForgeMigratedMappingConfiguration(String mappingsIdentifier, Path mappingsWorkingDir) {
        super(mappingsIdentifier, mappingsWorkingDir);
    }

    @Override
    protected void manipulateMappings(Project project, Path mappingsJar) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Path forgeCache = ForgeProvider.getForgeCache(project);
        Files.createDirectories(forgeCache, new FileAttribute[0]);
        boolean hasSrg = extension.shouldGenerateSrgTiny();
        boolean hasMojang = extension.isNeoForge();
        this.hashPath = forgeCache.resolve("mappings-migrated.hash");
        this.hash = 1L;
        this.rawTinyMappings = this.tinyMappings;
        this.rawTinyMappingsWithSrg = this.tinyMappingsWithSrg;
        this.rawTinyMappingsWithMojang = this.tinyMappingsWithMojang;
        Path rawTinyMappingsWithNs = hasSrg ? this.rawTinyMappingsWithSrg : (hasMojang ? this.rawTinyMappingsWithMojang : this.rawTinyMappings);
        this.tinyMappings = this.mappingsWorkingDir().resolve("mappings-migrated.tiny");
        this.tinyMappingsWithSrg = this.mappingsWorkingDir().resolve("mappings-srg-migrated.tiny");
        this.tinyMappingsWithMojang = this.mappingsWorkingDir().resolve("mappings-mojang-migrated.tiny");
        Path tinyMappingsWithNs = hasSrg ? this.tinyMappingsWithSrg : (hasMojang ? this.tinyMappingsWithMojang : this.tinyMappings);
        for (MappingsMigrator migrator : this.migrators) {
            this.hash = this.hash * 31L + migrator.setup(project, extension.getMinecraftProvider(), forgeCache, rawTinyMappingsWithNs, hasSrg, hasMojang);
        }
        if (!this.isOutdated(extension, hasSrg, hasMojang)) {
            project.getLogger().info(":manipulated {} mappings are up to date", (Object)((ModPlatform)((Object)extension.getPlatform().get())).id());
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        Files.copy(this.rawTinyMappings, this.tinyMappings, StandardCopyOption.REPLACE_EXISTING);
        Files.copy(rawTinyMappingsWithNs, tinyMappingsWithNs, StandardCopyOption.REPLACE_EXISTING);
        Files.writeString(this.hashPath, (CharSequence)Long.toString(this.hash), StandardCharsets.UTF_8, new OpenOption[0]);
        for (MappingsMigrator migrator : this.migrators) {
            Path path = Files.createTempFile("mappings-working", ".tiny", new FileAttribute[0]);
            Path pathWithNs = Files.createTempFile("mappings-working-ns", ".tiny", new FileAttribute[0]);
            Files.copy(this.tinyMappings, path, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(tinyMappingsWithNs, pathWithNs, StandardCopyOption.REPLACE_EXISTING);
            List<MappingsMigrator.MappingsEntry> entries = List.of(new MappingsMigrator.MappingsEntry(path), new MappingsMigrator.MappingsEntry(pathWithNs));
            migrator.migrate(project, entries);
            Files.copy(path, this.tinyMappings, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(pathWithNs, tinyMappingsWithNs, StandardCopyOption.REPLACE_EXISTING);
            Files.deleteIfExists(path);
            Files.deleteIfExists(pathWithNs);
        }
        project.getLogger().info(":manipulated {} mappings in " + String.valueOf(stopwatch.stop()), (Object)((ModPlatform)((Object)extension.getPlatform().get())).id());
    }

    private boolean isOutdated(LoomGradleExtension extension, boolean hasSrg, boolean hasMojang) throws IOException {
        if (extension.refreshDeps()) {
            return true;
        }
        if (Files.notExists(this.tinyMappings, new LinkOption[0])) {
            return true;
        }
        if (hasSrg && Files.notExists(this.tinyMappingsWithSrg, new LinkOption[0])) {
            return true;
        }
        if (hasMojang && Files.notExists(this.tinyMappingsWithMojang, new LinkOption[0])) {
            return true;
        }
        if (Files.notExists(this.hashPath, new LinkOption[0])) {
            return true;
        }
        String hashStr = Files.readString(this.hashPath, StandardCharsets.UTF_8);
        return !Long.toString(this.hash).equals(hashStr);
    }
}

