/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.tool;

import dev.architectury.loom.forge.tool.JavaExecutableFetcher;
import dev.architectury.loom.util.NullOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.Nullable;

public final class ForgeToolExecutor {
    private ForgeToolExecutor() {
    }

    public static boolean shouldShowVerboseStdout(Project project) {
        return project.getGradle().getStartParameter().getLogLevel().compareTo((Enum)LogLevel.LIFECYCLE) < 0;
    }

    public static boolean shouldShowVerboseStderr(Project project) {
        return ForgeToolExecutor.shouldShowVerboseStdout(project) || project.getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS;
    }

    public static Settings getDefaultSettings(Project project) {
        Settings settings = (Settings)project.getObjects().newInstance(Settings.class, new Object[0]);
        settings.getExecutable().set(JavaExecutableFetcher.getJavaToolchainExecutable(project));
        settings.getShowVerboseStdout().set((Object)ForgeToolExecutor.shouldShowVerboseStdout(project));
        settings.getShowVerboseStderr().set((Object)ForgeToolExecutor.shouldShowVerboseStderr(project));
        settings.getProgramArgs();
        settings.getJvmArgs();
        settings.getMainClass();
        settings.getExecClasspath();
        return settings;
    }

    static ExecResult exec(ExecOperations execOperations, Settings settings) {
        return execOperations.javaexec(spec -> ForgeToolExecutor.applyToSpec(settings, spec));
    }

    private static void applyToSpec(Settings settings, JavaExecSpec spec) {
        String mainClass;
        @Nullable String executable = (String)settings.getExecutable().getOrNull();
        if (executable != null) {
            spec.setExecutable(executable);
        }
        if ((mainClass = (String)settings.getMainClass().getOrNull()) != null) {
            spec.getMainClass().set((Object)mainClass);
        }
        spec.setArgs((List)settings.getProgramArgs().get());
        spec.setJvmArgs((List)settings.getJvmArgs().get());
        spec.setClasspath((FileCollection)settings.getExecClasspath());
        if (((Boolean)settings.getShowVerboseStdout().get()).booleanValue()) {
            spec.setStandardOutput((OutputStream)System.out);
        } else {
            spec.setStandardOutput((OutputStream)NullOutputStream.INSTANCE);
        }
        if (((Boolean)settings.getShowVerboseStderr().get()).booleanValue()) {
            spec.setErrorOutput((OutputStream)System.err);
        } else {
            spec.setErrorOutput((OutputStream)NullOutputStream.INSTANCE);
        }
    }

    static void copySettings(Settings source, Settings target) {
        target.getExecutable().set(source.getExecutable());
        target.getMainClass().set(source.getMainClass());
        target.getProgramArgs().set(source.getProgramArgs());
        target.getJvmArgs().set(source.getJvmArgs());
        target.getExecClasspath().setFrom((Iterable)source.getExecClasspath());
        target.getShowVerboseStdout().set(source.getShowVerboseStdout());
        target.getShowVerboseStderr().set(source.getShowVerboseStderr());
    }

    public static interface Settings {
        @Input
        @Optional
        public Property<String> getExecutable();

        @Input
        @Optional
        public ListProperty<String> getProgramArgs();

        @Input
        @Optional
        public ListProperty<String> getJvmArgs();

        @Input
        @Optional
        public Property<String> getMainClass();

        @Classpath
        public ConfigurableFileCollection getExecClasspath();

        @Input
        public Property<Boolean> getShowVerboseStdout();

        @Input
        public Property<Boolean> getShowVerboseStderr();

        default public void classpath(Object ... paths) {
            this.getExecClasspath().from(paths);
        }

        default public void setClasspath(Object ... paths) {
            this.getExecClasspath().setFrom(paths);
        }

        default public void args(String ... args) {
            this.getProgramArgs().addAll((Object[])args);
        }

        default public void args(Collection<String> args) {
            this.getProgramArgs().addAll(args);
        }

        default public void setArgs(List<String> args) {
            this.getProgramArgs().set(args);
        }

        default public void jvmArgs(String ... args) {
            this.getJvmArgs().addAll((Object[])args);
        }

        default public void jvmArgs(Collection<String> args) {
            this.getJvmArgs().addAll(args);
        }
    }
}

