/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingSpecBuilderImpl;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingsFactory;
import net.fabricmc.loom.configuration.providers.mappings.TinyMappingsService;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.lorenztiny.TinyMappingsJoiner;
import net.fabricmc.mappingio.tree.MappingTree;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.remapper.MercuryRemapper;
import org.gradle.api.Action;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateMappingsService
extends Service<Options> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateMappingsService.class);
    private static final ServiceType<Options, MigrateMappingsService> TYPE = new ServiceType<Options, MigrateMappingsService>(Options.class, MigrateMappingsService.class);

    public MigrateMappingsService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public static Provider<Options> createOptions(Project project, Provider<String> targetMappings, DirectoryProperty inputDir, DirectoryProperty outputDir) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Provider from = project.provider(() -> "intermediary");
        Provider to = project.provider(() -> "named");
        JavaVersion javaVersion = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceCompatibility();
        ConfigurableFileCollection classpath = project.getObjects().fileCollection();
        classpath.from(new Object[]{project.getConfigurations().getByName("compileClasspath")});
        classpath.from(new Object[]{extension.getMinecraftJars(MappingsNamespace.INTERMEDIARY)});
        classpath.from(new Object[]{extension.getMinecraftJars(MappingsNamespace.NAMED)});
        if (extension.isForge()) {
            classpath.from(new Object[]{extension.getMinecraftJars(MappingsNamespace.SRG)});
        } else if (extension.isNeoForge()) {
            classpath.from(new Object[]{extension.getMinecraftJars(MappingsNamespace.MOJANG)});
        }
        return TYPE.create(project, (Action<Options>)((Action)o -> {
            FileCollection targetMappingsFile = MigrateMappingsService.getTargetMappingsFile(project, (String)targetMappings.get());
            o.getSourceMappings().set(MappingsService.createOptionsWithProjectMappings(project, (Provider<String>)from, (Provider<String>)to));
            o.getTargetMappings().set(TinyMappingsService.createOptions(project, targetMappingsFile, "mappings/mappings.tiny"));
            o.getSourceCompatibility().set((Object)javaVersion.toString());
            o.getInputDir().set((Provider)inputDir);
            o.getClasspath().from(new Object[]{classpath});
            o.getOutputDir().set((Provider)outputDir);
        }));
    }

    public void migrateMapppings() throws IOException {
        Path inputDir = ((Directory)((Options)this.getOptions()).getInputDir().get()).getAsFile().toPath();
        Path outputDir = ((Directory)((Options)this.getOptions()).getOutputDir().get()).getAsFile().toPath();
        if (!Files.exists(inputDir, new LinkOption[0]) || !Files.isDirectory(inputDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Could not find input directory: " + String.valueOf(inputDir.toAbsolutePath()));
        }
        Files.deleteIfExists(outputDir);
        Files.createDirectories(outputDir, new FileAttribute[0]);
        Mercury mercury = new Mercury();
        mercury.setGracefulClasspathChecks(true);
        mercury.setSourceCompatibility((String)((Options)this.getOptions()).getSourceCompatibility().get());
        MappingsService sourceMappingsService = (MappingsService)this.getServiceFactory().get((MappingsService.Options)((Options)this.getOptions()).getSourceMappings().get());
        TinyMappingsService targetMappingsService = (TinyMappingsService)this.getServiceFactory().get((TinyMappingsService.Options)((Options)this.getOptions()).getTargetMappings().get());
        MappingSet mappingSet = new TinyMappingsJoiner((MappingTree)sourceMappingsService.getMemoryMappingTree(), MappingsNamespace.NAMED.toString(), (MappingTree)targetMappingsService.getMappingTree(), MappingsNamespace.NAMED.toString(), MappingsNamespace.INTERMEDIARY.toString()).read();
        mercury.getProcessors().add(MercuryRemapper.create((MappingSet)mappingSet));
        for (File file : ((Options)this.getOptions()).getClasspath().getFiles()) {
            mercury.getClassPath().add(file.toPath());
        }
        try {
            mercury.rewrite(inputDir, outputDir);
        }
        catch (Exception e) {
            LOGGER.warn("Could not remap fully!", (Throwable)e);
        }
        System.gc();
    }

    private static FileCollection getTargetMappingsFile(Project project, String mappings) {
        if (mappings == null || mappings.isEmpty()) {
            throw new IllegalArgumentException("No mappings were specified. Use --mappings=\"\" to specify target mappings");
        }
        try {
            if (mappings.startsWith("net.minecraft:mappings:")) {
                if (!mappings.endsWith(":" + LoomGradleExtension.get(project).getMinecraftProvider().minecraftVersion())) {
                    throw new UnsupportedOperationException("Migrating Mojang mappings is currently only supported for the specified minecraft version");
                }
                LayeredMappingsFactory dep = new LayeredMappingsFactory(LayeredMappingSpecBuilderImpl.buildOfficialMojangMappings());
                return project.files(new Object[]{dep.resolve(project).toFile()});
            }
            Dependency dependency = project.getDependencies().create((Object)mappings);
            return project.getConfigurations().detachedConfiguration(new Dependency[]{dependency});
        }
        catch (IllegalDependencyNotation ignored) {
            LOGGER.info("Could not locate mappings, presuming V2 Yarn");
            return project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create(Map.of("group", "net.fabricmc", "name", "yarn", "version", mappings, "classifier", "v2"))});
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to resolve mappings", e);
        }
    }

    public static interface Options
    extends Service.Options {
        @Nested
        public Property<MappingsService.Options> getSourceMappings();

        @Nested
        public Property<TinyMappingsService.Options> getTargetMappings();

        @InputDirectory
        public DirectoryProperty getInputDir();

        @Input
        public Property<String> getSourceCompatibility();

        @InputFiles
        public ConfigurableFileCollection getClasspath();

        @OutputDirectory
        public DirectoryProperty getOutputDir();
    }
}

