/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.stream.Stream;
import net.fabricmc.loom.configuration.providers.forge.ConfigValue;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.StepLogic;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.provider.Provider;

public final class InjectLogic
extends StepLogic<Service.Options> {
    public static final ServiceType<Service.Options, InjectLogic> TYPE = new ServiceType<Service.Options, InjectLogic>(Service.Options.class, InjectLogic.class);

    public static Provider<Service.Options> createOptions(StepLogic.SetupContext context) {
        return TYPE.create(context.project(), (Action<Service.Options>)((Action)options -> {}));
    }

    public InjectLogic(Service.Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    @Override
    public void execute(StepLogic.ExecutionContext context) throws IOException {
        Path injectedFiles = Path.of(context.resolve(new ConfigValue.Variable("inject")), new String[0]);
        Path input = Path.of(context.resolve(new ConfigValue.Variable("input")), new String[0]);
        Path output = context.setOutput("output.jar");
        Files.copy(input, output, StandardCopyOption.REPLACE_EXISTING);
        try (FileSystemUtil.Delegate targetFs = FileSystemUtil.getJarFileSystem(output, false);){
            FileSystem fs = targetFs.get();
            try (Stream<Path> paths = Files.walk(injectedFiles, new FileVisitOption[0]);){
                Iterator iter = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).iterator();
                while (iter.hasNext()) {
                    Path from = (Path)iter.next();
                    Path relative = injectedFiles.relativize(from);
                    Path to = fs.getPath(relative.toString().replace(relative.getFileSystem().getSeparator(), "/"), new String[0]);
                    if (to.getParent() != null) {
                        Files.createDirectories(to.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
    }
}

