/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig;

import com.google.common.base.Stopwatch;
import dev.architectury.loom.forge.tool.ForgeToolExecutor;
import dev.architectury.loom.forge.tool.ForgeToolService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loom.configuration.providers.forge.ConfigValue;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpConfigStep;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.StepLogic;
import net.fabricmc.loom.util.download.Download;
import net.fabricmc.loom.util.download.DownloadBuilder;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.jetbrains.annotations.Nullable;

public final class McpExecutor
extends Service<Options> {
    public static final ServiceType<Options, McpExecutor> TYPE = new ServiceType<Options, McpExecutor>(Options.class, McpExecutor.class);
    private static final Logger LOGGER = Logging.getLogger(McpExecutor.class);
    private static final LogLevel STEP_LOG_LEVEL = LogLevel.LIFECYCLE;
    private final Path cache;
    private final Map<String, String> config;
    private final Map<String, String> extraConfig = new HashMap<String, String>();

    public McpExecutor(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
        this.config = new HashMap<String, String>((Map)options.getInitialConfig().get());
        this.cache = ((Directory)options.getCache().get()).getAsFile().toPath();
    }

    private Path getStepCache(String step) {
        return this.cache.resolve(step);
    }

    private Path createStepCache(String step) throws IOException {
        Path stepCache = this.getStepCache(step);
        Files.createDirectories(stepCache, new FileAttribute[0]);
        return stepCache;
    }

    private String resolve(McpConfigStep step, ConfigValue value) {
        return value.resolve(variable -> {
            String name = variable.name();
            @Nullable ConfigValue valueFromStep = step.config().get(name);
            if (valueFromStep != null && !valueFromStep.equals(variable)) {
                return this.resolve(step, valueFromStep);
            }
            if (this.config.containsKey(name)) {
                return this.config.get(name);
            }
            if (this.extraConfig.containsKey(name)) {
                return this.extraConfig.get(name);
            }
            if (name.equals("log")) {
                return this.cache.resolve("log.log").toAbsolutePath().toString();
            }
            throw new IllegalArgumentException("Unknown MCP config variable: " + name);
        });
    }

    public Path execute() throws IOException {
        List steps = (List)((Options)this.getOptions()).getStepsToExecute().get();
        int totalSteps = steps.size();
        int currentStepIndex = 0;
        LOGGER.log(STEP_LOG_LEVEL, ":executing {} MCP steps", new Object[]{totalSteps});
        for (McpConfigStep currentStep : steps) {
            StepLogic<?> stepLogic = this.getStepLogic(currentStep.name());
            LOGGER.log(STEP_LOG_LEVEL, ":step {}/{} - {}", new Object[]{++currentStepIndex, totalSteps, stepLogic.getDisplayName(currentStep.name())});
            Stopwatch stopwatch = Stopwatch.createStarted();
            stepLogic.execute(new ExecutionContextImpl(currentStep));
            LOGGER.log(STEP_LOG_LEVEL, ":{} done in {}", new Object[]{currentStep.name(), stopwatch.stop()});
        }
        return Path.of(this.extraConfig.get("output"), new String[0]);
    }

    private StepLogic<?> getStepLogic(String name) {
        Provider options = ((Options)this.getOptions()).getStepLogicOptions().getting((Object)name);
        return (StepLogic)this.getServiceFactory().get(options);
    }

    public static interface Options
    extends Service.Options {
        @Nested
        public MapProperty<String, Service.Options> getStepLogicOptions();

        @Input
        public ListProperty<McpConfigStep> getStepsToExecute();

        @InputFile
        public RegularFileProperty getMappings();

        @Input
        public MapProperty<String, String> getInitialConfig();

        @Input
        public Property<Boolean> getOffline();

        @Input
        public Property<Boolean> getManualRefreshDeps();

        @Nested
        public Property<ForgeToolService.Options> getToolServiceOptions();

        @Internal
        public DirectoryProperty getCache();
    }

    private class ExecutionContextImpl
    implements StepLogic.ExecutionContext {
        private final McpConfigStep step;

        ExecutionContextImpl(McpConfigStep step) {
            this.step = step;
        }

        @Override
        public Logger logger() {
            return LOGGER;
        }

        @Override
        public Path setOutput(String fileName) throws IOException {
            return this.setOutput(this.cache().resolve(fileName));
        }

        @Override
        public Path setOutput(Path output) {
            String absolutePath = output.toAbsolutePath().toString();
            McpExecutor.this.extraConfig.put("output", absolutePath);
            McpExecutor.this.extraConfig.put(this.step.name() + "Output", absolutePath);
            return output;
        }

        @Override
        public Path cache() throws IOException {
            return McpExecutor.this.createStepCache(this.step.name());
        }

        @Override
        public Path mappings() {
            return ((RegularFile)((Options)McpExecutor.this.getOptions()).getMappings().get()).getAsFile().toPath();
        }

        @Override
        public String resolve(ConfigValue value) {
            return McpExecutor.this.resolve(this.step, value);
        }

        @Override
        public DownloadBuilder downloadBuilder(String url) {
            DownloadBuilder builder;
            try {
                builder = Download.create(url);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to create downloader for: " + String.valueOf(e));
            }
            if (((Boolean)((Options)McpExecutor.this.getOptions()).getOffline().get()).booleanValue()) {
                builder.offline();
            }
            if (((Boolean)((Options)McpExecutor.this.getOptions()).getManualRefreshDeps().get()).booleanValue()) {
                builder.forceDownload();
            }
            return builder;
        }

        @Override
        public void javaexec(Action<? super ForgeToolExecutor.Settings> configurator) {
            ForgeToolService toolService = (ForgeToolService)McpExecutor.this.getServiceFactory().get(((Options)McpExecutor.this.getOptions()).getToolServiceOptions());
            toolService.exec(configurator);
        }
    }
}

