/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.build.IntermediaryNamespaces;
import net.fabricmc.loom.extension.RemapperExtensionHolder;
import net.fabricmc.loom.task.AbstractRemapJarTask;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.task.service.MixinAPMappingService;
import net.fabricmc.loom.task.service.TinyRemapperServiceInterface;
import net.fabricmc.loom.util.TinyRemapperLoggerAdapter;
import net.fabricmc.loom.util.kotlin.KotlinClasspathService;
import net.fabricmc.loom.util.kotlin.KotlinRemapperClassloader;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.InputTag;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrLogger;
import net.fabricmc.tinyremapper.extension.mixin.MixinExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.Nullable;

public class TinyRemapperService
extends Service<Options>
implements TinyRemapperServiceInterface,
Closeable {
    public static final ServiceType<Options, TinyRemapperService> TYPE = new ServiceType<Options, TinyRemapperService>(Options.class, TinyRemapperService.class);
    private TinyRemapper tinyRemapper;
    @Nullable
    private KotlinRemapperClassloader kotlinRemapperClassloader;
    private final Map<String, InputTag> inputTagMap = new HashMap<String, InputTag>();
    private final HashSet<Path> classpath = new HashSet();
    private boolean isRemapping = false;

    public static Provider<Options> createOptions(AbstractRemapJarTask remapJarTask) {
        Project project = remapJarTask.getProject();
        return TYPE.create(project, (Action<Options>)((Action)options -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            ConfigurationContainer configurations = project.getConfigurations();
            boolean legacyMixin = (Boolean)extension.getMixin().getUseLegacyMixinAp().get();
            FileCollection classpath = remapJarTask.getClasspath().minus((FileCollection)configurations.getByName("minecraftLibraries")).minus((FileCollection)configurations.getByName("minecraftRuntimeLibraries"));
            options.getFrom().set(remapJarTask.getSourceNamespace());
            options.getTo().set(remapJarTask.getTargetNamespace());
            options.getMappings().add(MappingsService.createForRemapTask(remapJarTask));
            if (legacyMixin) {
                options.getMixinApMappings().set(MixinAPMappingService.createOptions(project, options.getFrom(), (Provider<String>)options.getTo().map(to -> IntermediaryNamespaces.replaceMixinIntermediaryNamespace(project, to))));
            }
            options.getUselegacyMixinAP().set((Object)legacyMixin);
            options.getKotlinClasspathService().set(KotlinClasspathService.createOptions(project));
            options.getClasspath().from(new Object[]{classpath});
            options.getKnownIndyBsms().set(((Set)extension.getKnownIndyBsms().get()).stream().sorted().toList());
            options.getRemapperExtensions().set(extension.getRemapperExtensions());
        }));
    }

    public static Provider<Options> createSimple(Project project, Provider<String> from, Provider<String> to, ClasspathLibraries classpathLibraries) {
        return TYPE.create(project, (Action<Options>)((Action)options -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            FileCollection classpath = TinyRemapperService.getRemapClasspath(project, from, classpathLibraries);
            options.getFrom().set(from);
            options.getTo().set(to);
            options.getMappings().add(MappingsService.createOptionsWithProjectMappings(project, options.getFrom(), options.getTo()));
            options.getUselegacyMixinAP().set((Object)true);
            options.getClasspath().from(new Object[]{classpath});
            options.getKnownIndyBsms().set(((Set)extension.getKnownIndyBsms().get()).stream().sorted().toList());
            options.getRemapperExtensions().set(extension.getRemapperExtensions());
        }));
    }

    private static FileCollection getRemapClasspath(Project project, Provider<String> from, ClasspathLibraries classpathLibraries) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ConfigurationContainer configurations = project.getConfigurations();
        if (((String)from.get()).equals(MappingsNamespace.INTERMEDIARY.toString())) {
            ConfigurableFileCollection files = project.files(new Object[]{extension.getMinecraftJars(MappingsNamespace.INTERMEDIARY)});
            if (classpathLibraries == ClasspathLibraries.INCLUDE) {
                files = files.from(new Object[]{configurations.getByName("minecraftLibraries")});
            }
            return files;
        }
        if (classpathLibraries == ClasspathLibraries.INCLUDE) {
            return configurations.getByName("compileClasspath");
        }
        return configurations.getByName("compileClasspath").minus((FileCollection)configurations.getByName("minecraftLibraries")).minus((FileCollection)configurations.getByName("minecraftRuntimeLibraries"));
    }

    public TinyRemapperService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
        this.tinyRemapper = this.createTinyRemapper();
        this.readClasspath();
    }

    private TinyRemapper createTinyRemapper() {
        TinyRemapper.Builder builder = TinyRemapper.newRemapper((TrLogger)TinyRemapperLoggerAdapter.INSTANCE).withKnownIndyBsm(Set.copyOf((Collection)((Options)this.getOptions()).getKnownIndyBsms().get()));
        for (Service.Options options : (List)((Options)this.getOptions()).getMappings().get()) {
            MappingsService mappingsService = (MappingsService)this.getServiceFactory().get(options);
            builder.withMappings(mappingsService.getMappingsProvider());
        }
        if (!((Boolean)((Options)this.getOptions()).getUselegacyMixinAP().get()).booleanValue()) {
            builder.extension((TinyRemapper.Extension)new MixinExtension());
        }
        if (((Options)this.getOptions()).getKotlinClasspathService().isPresent()) {
            KotlinClasspathService kotlinClasspathService = (KotlinClasspathService)this.getServiceFactory().get(((Options)this.getOptions()).getKotlinClasspathService());
            this.kotlinRemapperClassloader = KotlinRemapperClassloader.create(kotlinClasspathService);
            builder.extension((TinyRemapper.Extension)this.kotlinRemapperClassloader.getTinyRemapperExtension());
        }
        for (RemapperExtensionHolder holder : (List)((Options)this.getOptions()).getRemapperExtensions().get()) {
            holder.apply(builder, (String)((Options)this.getOptions()).getFrom().get(), (String)((Options)this.getOptions()).getTo().get());
        }
        if (((Boolean)((Options)this.getOptions()).getUselegacyMixinAP().get()).booleanValue()) {
            for (Service.Options options : (List)((Options)this.getOptions()).getMixinApMappings().get()) {
                MixinAPMappingService mixinAPMappingService = (MixinAPMappingService)this.getServiceFactory().get(options);
                IMappingProvider provider = mixinAPMappingService.getMappingsProvider();
                if (provider == null) continue;
                builder.withMappings(provider);
            }
        }
        return builder.build();
    }

    public InputTag getOrCreateTag(Path file) {
        InputTag tag = this.inputTagMap.get(file.toAbsolutePath().toString());
        if (tag == null) {
            tag = this.tinyRemapper.createInputTag();
            this.inputTagMap.put(file.toAbsolutePath().toString(), tag);
        }
        return tag;
    }

    @Override
    public TinyRemapper getTinyRemapperForRemapping() {
        this.isRemapping = true;
        return Objects.requireNonNull(this.tinyRemapper, "Tiny remapper has not been setup");
    }

    @Override
    public TinyRemapper getTinyRemapperForInputs() {
        if (this.isRemapping) {
            throw new IllegalStateException("Cannot read inputs as remapping has already started");
        }
        return this.tinyRemapper;
    }

    private void readClasspath() {
        ArrayList<Path> toRead = new ArrayList<Path>();
        for (File file : ((Options)this.getOptions()).getClasspath().getFiles()) {
            Path path = file.toPath();
            if (this.classpath.contains(path) || Files.notExists(path, new LinkOption[0])) continue;
            toRead.add(path);
            this.classpath.add(path);
        }
        if (toRead.isEmpty()) {
            return;
        }
        this.tinyRemapper.readClassPath((Path[])toRead.toArray(Path[]::new));
    }

    @Override
    public void close() throws IOException {
        if (this.tinyRemapper != null) {
            this.tinyRemapper.finish();
            this.tinyRemapper = null;
        }
        if (this.kotlinRemapperClassloader != null) {
            this.kotlinRemapperClassloader.close();
        }
    }

    public static enum ClasspathLibraries {
        EXCLUDE,
        INCLUDE;

    }

    public static interface Options
    extends Service.Options {
        @Input
        public Property<String> getFrom();

        @Input
        public Property<String> getTo();

        @Nested
        public ListProperty<MappingsService.Options> getMappings();

        @Input
        public Property<Boolean> getUselegacyMixinAP();

        @Nested
        public ListProperty<MixinAPMappingService.Options> getMixinApMappings();

        @Nested
        @Optional
        public Property<KotlinClasspathService.Options> getKotlinClasspathService();

        @InputFiles
        public ConfigurableFileCollection getClasspath();

        @Input
        public ListProperty<String> getKnownIndyBsms();

        @Input
        public ListProperty<RemapperExtensionHolder> getRemapperExtensions();
    }
}

