/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerRemapper;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.accesswidener.AccessWidenerWriter;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.fmj.ModMetadataFabricModJson;
import org.objectweb.asm.commons.Remapper;

public class AccessWidenerUtils {
    public static byte[] remapAccessWidener(byte[] input, Remapper remapper) {
        int version = AccessWidenerReader.readVersion((byte[])input);
        AccessWidenerWriter writer = new AccessWidenerWriter(version);
        AccessWidenerRemapper awRemapper = new AccessWidenerRemapper((AccessWidenerVisitor)writer, remapper, MappingsNamespace.INTERMEDIARY.toString(), MappingsNamespace.NAMED.toString());
        AccessWidenerReader reader = new AccessWidenerReader((AccessWidenerVisitor)awRemapper);
        reader.read(input);
        return writer.write();
    }

    public static AccessWidenerData readAccessWidenerData(Path inputJar, ModPlatform platform) throws IOException {
        if (!FabricModJsonFactory.isModJar(inputJar, platform)) {
            return null;
        }
        FabricModJson fabricModJson = FabricModJsonFactory.createFromZip(inputJar);
        if (platform.isForgeLike() && !(fabricModJson instanceof ModMetadataFabricModJson)) {
            return null;
        }
        List<String> classTweakers = List.copyOf(fabricModJson.getClassTweakers().keySet());
        if (classTweakers.isEmpty()) {
            return null;
        }
        if (classTweakers.size() != 1) {
            throw new UnsupportedOperationException("TODO: support multiple class tweakers");
        }
        String accessWidenerPath = classTweakers.get(0);
        byte[] accessWidener = fabricModJson.getSource().read(accessWidenerPath);
        AccessWidenerReader.Header header = AccessWidenerReader.readHeader((byte[])accessWidener);
        return new AccessWidenerData(accessWidenerPath, header, accessWidener);
    }

    public record AccessWidenerData(String path, AccessWidenerReader.Header header, byte[] content) {
    }
}

