/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge;

import dev.architectury.loom.forge.tool.ForgeToolExecutor;
import dev.architectury.loom.util.NullOutputStream;
import dev.architectury.loom.util.TempFiles;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.build.IntermediaryNamespaces;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.task.service.SourceRemapperService;
import net.fabricmc.loom.util.DependencyDownloader;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.ThreadingUtils;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.jetbrains.annotations.Nullable;

public final class ForgeSourcesService
extends Service<Options> {
    public static ServiceType<Options, ForgeSourcesService> TYPE = new ServiceType<Options, ForgeSourcesService>(Options.class, ForgeSourcesService.class);
    private static final Logger LOGGER = Logging.getLogger(ForgeSourcesService.class);

    public static Provider<Options> createOptions(Project project) {
        return TYPE.maybeCreate(project, options -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            if (!extension.isForgeLike()) {
                return false;
            }
            String sourceDependency = extension.getForgeUserdevProvider().getConfig().sources();
            options.getForgeSourceJars().from(new Object[]{DependencyDownloader.download(project, sourceDependency)});
            options.getSourceRemapperService().set(SourceRemapperService.TYPE.create(project, (Action<SourceRemapperService.Options>)((Action)sro -> {
                MappingsNamespace sourceNamespace = IntermediaryNamespaces.intermediaryNamespace(project);
                String targetNamespace = MappingsNamespace.NAMED.toString();
                sro.getMappings().set(MappingsService.createOptionsWithProjectMappings(project, (Provider<String>)project.provider(sourceNamespace::toString), (Provider<String>)project.provider(() -> targetNamespace)));
                sro.getJavaCompileRelease().set((Object)SourceRemapperService.getJavaCompileRelease(project));
                sro.getClasspath().from(new Object[]{DependencyDownloader.download(project, LoomVersions.JETBRAINS_ANNOTATIONS.mavenNotation())});
                sro.getClasspath().from(new Object[]{extension.getMinecraftJars(sourceNamespace)});
                sro.getClasspath().from(new Object[]{project.getConfigurations().getByName("minecraftLibraries")});
                TinyRemapperHelper.JSR_TO_JETBRAINS.forEach((from, to) -> {
                    Pair<String, String> mapping = new Pair<String, String>((String)from, (String)to);
                    sro.getAdditionalClassMappings().add(mapping);
                });
            })));
            options.getShouldShowVerboseStderr().set((Object)ForgeToolExecutor.shouldShowVerboseStderr(project));
            return true;
        });
    }

    public ForgeSourcesService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public static void addForgeSourcesDuringProjectConfiguration(Project project, ServiceFactory serviceFactory) throws IOException {
        List<Path> minecraftJars = LoomGradleExtension.get(project).getMinecraftJars(MappingsNamespace.NAMED);
        if (minecraftJars.isEmpty()) {
            throw new IllegalStateException("Could not find Minecraft jar for Forge sources");
        }
        if (minecraftJars.size() > 1) {
            return;
        }
        Path minecraftJar = minecraftJars.getFirst();
        Path sourcesJar = GenerateSourcesTask.getJarFileWithSuffix("-sources.jar", minecraftJar).toPath();
        if (!Files.exists(sourcesJar, new LinkOption[0])) {
            ForgeSourcesService service = (ForgeSourcesService)serviceFactory.get(ForgeSourcesService.createOptions(project));
            service.addForgeSources(minecraftJar, sourcesJar);
        }
    }

    public void addForgeSources(@Nullable Path minecraftJar, Path sourcesJar) throws IOException {
        try (FileSystemUtil.Delegate inputFs = minecraftJar == null ? null : FileSystemUtil.getJarFileSystem(minecraftJar, true);
             FileSystemUtil.Delegate outputFs = FileSystemUtil.getJarFileSystem(sourcesJar, true);){
            ThreadingUtils.TaskCompleter taskCompleter = ThreadingUtils.taskCompleter();
            this.provideForgeSources(path -> {
                Path inputPath;
                Path path2 = inputPath = inputFs == null ? null : inputFs.get().getPath(path.replace(".java", ".class"), new String[0]);
                if (inputPath != null && Files.notExists(inputPath, new LinkOption[0])) {
                    LOGGER.info("Discarding forge source file {} as it does not exist in the input jar", path);
                    return false;
                }
                return !path.contains("$");
            }, (path, bytes) -> {
                Path fsPath = outputFs.get().getPath((String)path, new String[0]);
                if (fsPath.getParent() != null) {
                    try {
                        Files.createDirectories(fsPath.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                taskCompleter.add(() -> {
                    LOGGER.info("Added forge source file {}", path);
                    Files.write(fsPath, bytes, StandardOpenOption.CREATE);
                });
            });
            taskCompleter.complete();
        }
    }

    private void provideForgeSources(Predicate<String> classFilter, BiConsumer<String, byte[]> consumer) throws IOException {
        ArrayList<Path> forgeInstallerSources = new ArrayList<Path>();
        for (File file : ((Options)this.getOptions()).getForgeSourceJars()) {
            forgeInstallerSources.add(file.toPath());
            LOGGER.info("Found forge source jar: {}", (Object)file);
        }
        LOGGER.lifecycle(":found {} forge source jars", new Object[]{forgeInstallerSources.size()});
        Map<String, byte[]> forgeSources = ForgeSourcesService.extractSources(forgeInstallerSources);
        forgeSources.keySet().removeIf(classFilter.negate());
        LOGGER.lifecycle(":extracted {} forge source classes", new Object[]{forgeSources.size()});
        try (TempFiles tempFiles = new TempFiles();){
            this.remapSources(tempFiles, forgeSources);
        }
        forgeSources.forEach(consumer);
    }

    private void remapSources(TempFiles tempFiles, Map<String, byte[]> sources) throws IOException {
        Path tmpInput = tempFiles.file("tmpInputForgeSources", ".jar");
        Files.delete(tmpInput);
        Path tmpOutput = tempFiles.file("tmpInputForgeSources", ".jar");
        Files.delete(tmpOutput);
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(tmpInput, true);){
            ThreadingUtils.TaskCompleter taskCompleter = ThreadingUtils.taskCompleter();
            for (Map.Entry<String, byte[]> entry : sources.entrySet()) {
                Path path = delegate.get().getPath(entry.getKey(), new String[0]);
                if (path.getParent() != null) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                taskCompleter.add(() -> Files.write(path, (byte[])entry.getValue(), StandardOpenOption.CREATE));
            }
            taskCompleter.complete();
        }
        PrintStream out = System.out;
        PrintStream err = System.err;
        if (!((Boolean)((Options)this.getOptions()).getShouldShowVerboseStderr().get()).booleanValue()) {
            System.setOut(new PrintStream(NullOutputStream.INSTANCE));
            System.setErr(new PrintStream(NullOutputStream.INSTANCE));
        }
        SourceRemapperService remapperService = (SourceRemapperService)this.getServiceFactory().get(((Options)this.getOptions()).getSourceRemapperService());
        remapperService.remapSourcesJar(tmpInput, tmpOutput);
        if (!((Boolean)((Options)this.getOptions()).getShouldShowVerboseStderr().get()).booleanValue()) {
            System.setOut(out);
            System.setErr(err);
        }
        int[] failedToRemap = new int[]{0};
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(tmpOutput, false);){
            ThreadingUtils.TaskCompleter taskCompleter = ThreadingUtils.taskCompleter();
            for (Map.Entry<String, byte[]> entry : new HashSet<Map.Entry<String, byte[]>>(sources.entrySet())) {
                taskCompleter.add(() -> {
                    Path path = delegate.get().getPath((String)entry.getKey(), new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        sources.put((String)entry.getKey(), Files.readAllBytes(path));
                    } else {
                        sources.remove(entry.getKey());
                        LOGGER.error("Failed to remap sources for " + (String)entry.getKey());
                        failedToRemap[0] = failedToRemap[0] + 1;
                    }
                });
            }
            taskCompleter.complete();
        }
        if (failedToRemap[0] > 0) {
            LOGGER.error("Failed to remap {} forge sources", (Object)failedToRemap[0]);
        }
    }

    private static Map<String, byte[]> extractSources(List<Path> forgeInstallerSources) throws IOException {
        ConcurrentHashMap<String, byte[]> sources = new ConcurrentHashMap<String, byte[]>();
        ThreadingUtils.TaskCompleter taskCompleter = ThreadingUtils.taskCompleter();
        for (Path path : forgeInstallerSources) {
            FileSystemUtil.Delegate system = FileSystemUtil.getJarFileSystem(path, false);
            taskCompleter.onComplete(stopwatch -> system.close());
            for (Path filePath : Files.walk(system.get().getPath("/", new String[0]), new FileVisitOption[0])::iterator) {
                if (!Files.isRegularFile(filePath, new LinkOption[0]) || !filePath.getFileName().toString().endsWith(".java")) continue;
                taskCompleter.add(() -> sources.put(filePath.toString(), Files.readAllBytes(filePath)));
            }
        }
        taskCompleter.complete();
        return sources;
    }

    public static interface Options
    extends Service.Options {
        @InputFiles
        public ConfigurableFileCollection getForgeSourceJars();

        @Nested
        public Property<SourceRemapperService.Options> getSourceRemapperService();

        @Input
        public Property<Boolean> getShouldShowVerboseStderr();
    }
}

