/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SourceSet;

public abstract class ClientEntriesService<O extends Options>
extends Service<O> {
    public ClientEntriesService(O options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public abstract List<String> getClientOnlyEntries();

    static List<String> getRootPaths(Set<File> files) {
        return files.stream().map(root -> {
            Object rootPath = root.getAbsolutePath().replace("\\", "/");
            if (((String)rootPath).charAt(((String)rootPath).length() - 1) != '/') {
                rootPath = (String)rootPath + "/";
            }
            return rootPath;
        }).toList();
    }

    static Function<File, String> relativePath(List<String> rootPaths) {
        return file -> {
            String s = file.getAbsolutePath().replace("\\", "/");
            for (String rootPath : rootPaths) {
                if (!s.startsWith(rootPath)) continue;
                s = s.substring(rootPath.length());
            }
            return s;
        };
    }

    public static class Classes
    extends ClientEntriesService<Options> {
        public static final ServiceType<Options, Classes> TYPE = new ServiceType<Options, Classes>(Options.class, Classes.class);

        public static Provider<Options> createOptions(Project project, SourceSet sourceSet) {
            return TYPE.create(project, (Action<Options>)((Action)o -> {
                o.getAllOutputDirs().from(new Object[]{sourceSet.getOutput().getClassesDirs()});
                o.getAllOutputDirs().from(new Object[]{sourceSet.getOutput().getResourcesDir()});
            }));
        }

        public Classes(Options options, ServiceFactory serviceFactory) {
            super(options, serviceFactory);
        }

        @Override
        public List<String> getClientOnlyEntries() {
            Set outputFiles = ((Options)this.getOptions()).getAllOutputDirs().getAsFileTree().getFiles();
            List<String> rootPaths = Classes.getRootPaths(((Options)this.getOptions()).getAllOutputDirs().getFiles());
            return outputFiles.stream().map(Classes.relativePath(rootPaths)).toList();
        }

        public static interface Options
        extends net.fabricmc.loom.task.service.ClientEntriesService$Options {
            @InputFiles
            public ConfigurableFileCollection getAllOutputDirs();
        }
    }

    public static class Source
    extends ClientEntriesService<Options> {
        public static final ServiceType<Options, Source> TYPE = new ServiceType<Options, Source>(Options.class, Source.class);

        public static Provider<Options> createOptions(Project project, SourceSet sourceSet) {
            return TYPE.create(project, (Action<Options>)((Action)o -> {
                o.getAllSourceFiles().from(new Object[]{sourceSet.getAllSource().getAsFileTree()});
                o.getSourceDirectories().from(new Object[]{sourceSet.getAllSource().getSourceDirectories()});
            }));
        }

        public Source(Options options, ServiceFactory serviceFactory) {
            super(options, serviceFactory);
        }

        @Override
        public List<String> getClientOnlyEntries() {
            return ((Options)this.getOptions()).getAllSourceFiles().getFiles().stream().map(Source.relativePath(Source.getRootPaths(((Options)this.getOptions()).getSourceDirectories().getFiles()))).toList();
        }

        public static interface Options
        extends net.fabricmc.loom.task.service.ClientEntriesService$Options {
            @InputFiles
            public ConfigurableFileCollection getAllSourceFiles();

            @InputFiles
            public ConfigurableFileCollection getSourceDirectories();
        }
    }

    public static interface Options
    extends Service.Options {
    }
}

