/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.library.processors;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.loom.configuration.providers.minecraft.library.Library;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryContext;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryProcessor;
import net.fabricmc.loom.util.Platform;

public class ObjcBridgeUpgradeLibraryProcessor
extends LibraryProcessor {
    private static final String OBJC_BRIDGE_PREFIX = "ca.weblite:java-objc-bridge";
    private static final String OBJC_BRIDGE_VERSION = "1.1";
    private static final String OBJC_BRIDGE_NAME = "%s:%s".formatted("ca.weblite:java-objc-bridge", "1.1");

    public ObjcBridgeUpgradeLibraryProcessor(Platform platform, LibraryContext context) {
        super(platform, context);
    }

    @Override
    public LibraryProcessor.ApplicationResult getApplicationResult() {
        if (!this.context.usesLWJGL3()) {
            return LibraryProcessor.ApplicationResult.DONT_APPLY;
        }
        if (!this.platform.getOperatingSystem().isMacOS() || !this.platform.getArchitecture().isArm()) {
            return LibraryProcessor.ApplicationResult.DONT_APPLY;
        }
        return this.context.supportsArm64(Platform.OperatingSystem.MAC_OS) ? LibraryProcessor.ApplicationResult.DONT_APPLY : LibraryProcessor.ApplicationResult.MUST_APPLY;
    }

    @Override
    public Predicate<Library> apply(Consumer<Library> dependencyConsumer) {
        dependencyConsumer.accept(Library.fromMaven(OBJC_BRIDGE_NAME, Library.Target.RUNTIME));
        return library -> {
            if (library.is(OBJC_BRIDGE_PREFIX)) {
                return library.target() != Library.Target.NATIVES;
            }
            return true;
        };
    }
}

