/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.srg;

import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.function.UnaryOperator;
import net.fabricmc.loom.build.IntermediaryNamespaces;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.function.CollectionUtil;
import net.fabricmc.mappingio.tree.MappingTree;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public final class AtClassRemapper {
    public static void remap(Project project, Path jar, MappingTree mappings) throws IOException {
        Logger logger = project.getLogger();
        String sourceNamespace = IntermediaryNamespaces.intermediary(project);
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jar, false);){
            Path atPath = fs.getPath("META-INF/accesstransformer.cfg", new String[0]);
            if (Files.exists(atPath, new LinkOption[0])) {
                String atContent = Files.readString(atPath, StandardCharsets.UTF_8);
                String[] lines = atContent.split("\n");
                ArrayList<String> output = new ArrayList<String>(lines.length);
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i].trim();
                    if (line.startsWith("#") || line.isBlank()) {
                        output.add(i, line);
                        continue;
                    }
                    CharSequence[] parts = line.split("\\s+");
                    if (parts.length < 2) {
                        logger.warn("Invalid AT Line: " + line);
                        output.add(i, line);
                        continue;
                    }
                    String name = parts[1].replace('.', '/');
                    parts[1] = CollectionUtil.find(mappings.getClasses(), def -> def.getName(sourceNamespace).equals(name)).map(def -> def.getName("named")).orElse(name).replace('/', '.');
                    if (parts.length >= 3 && parts[2].contains("(")) {
                        parts[2] = ((String)parts[2]).substring(0, ((String)parts[2]).indexOf(40)) + AtClassRemapper.remapDescriptor(((String)parts[2]).substring(((String)parts[2]).indexOf(40)), s -> CollectionUtil.find(mappings.getClasses(), def -> def.getName(sourceNamespace).equals(s)).map(def -> def.getName("named")).orElse((String)s));
                    }
                    output.add(i, String.join((CharSequence)" ", parts));
                }
                Files.write(atPath, String.join((CharSequence)"\n", output).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
            }
        }
    }

    private static String remapDescriptor(String original, UnaryOperator<String> classMappings) {
        try {
            int c;
            StringReader reader = new StringReader(original);
            StringBuilder result = new StringBuilder();
            boolean insideClassName = false;
            StringBuilder className = new StringBuilder();
            while ((c = reader.read()) != -1) {
                if ((char)c == ';') {
                    insideClassName = false;
                    result.append((String)classMappings.apply(className.toString()));
                }
                if (insideClassName) {
                    className.append((char)c);
                } else {
                    result.append((char)c);
                }
                if (insideClassName || (char)c != 'L') continue;
                insideClassName = true;
                className.setLength(0);
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

