/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loom.util.DeletingFileVisitor;
import org.jetbrains.annotations.Nullable;

public final class TempFiles
implements Closeable {
    private final List<Path> directories = new ArrayList<Path>();
    private final List<Path> files = new ArrayList<Path>();

    public Path directory(@Nullable String prefix) throws IOException {
        Path directory = Files.createTempDirectory(prefix, new FileAttribute[0]);
        this.directories.add(directory);
        return directory;
    }

    public Path file(@Nullable String prefix, @Nullable String suffix) throws IOException {
        Path file = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        this.files.add(file);
        return file;
    }

    @Override
    public void close() throws IOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Path file : this.files) {
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        this.files.clear();
        for (Path directory : this.directories) {
            if (!Files.exists(directory, new LinkOption[0])) continue;
            try {
                Files.walkFileTree(directory, new DeletingFileVisitor());
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        this.directories.clear();
        if (!exceptions.isEmpty()) {
            IOException root = new IOException("Could not delete temporary files", (Throwable)exceptions.get(0));
            for (int i = 1; i < exceptions.size(); ++i) {
                root.addSuppressed((Throwable)exceptions.get(i));
            }
            throw root;
        }
    }
}

