/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.tool;

import dev.architectury.loom.forge.tool.JavaExecutableFetcher;
import dev.architectury.loom.util.NullOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.jetbrains.annotations.Nullable;

public abstract class ForgeToolExecutor {
    @Inject
    protected abstract ExecOperations getExecOperations();

    public static boolean shouldShowVerboseStdout(Project project) {
        return project.getGradle().getStartParameter().getLogLevel().compareTo((Enum)LogLevel.LIFECYCLE) < 0;
    }

    public static boolean shouldShowVerboseStderr(Project project) {
        return ForgeToolExecutor.shouldShowVerboseStdout(project) || project.getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS;
    }

    public static Settings getDefaultSettings(Project project) {
        Settings settings = (Settings)project.getObjects().newInstance(Settings.class, new Object[0]);
        settings.getExecutable().set(JavaExecutableFetcher.getJavaToolchainExecutable(project));
        settings.getShowVerboseStdout().set((Object)ForgeToolExecutor.shouldShowVerboseStdout(project));
        settings.getShowVerboseStderr().set((Object)ForgeToolExecutor.shouldShowVerboseStderr(project));
        return settings;
    }

    public static ExecResult exec(Project project, Action<? super Settings> configurator) {
        Settings settings = ForgeToolExecutor.getDefaultSettings(project);
        configurator.execute((Object)settings);
        return ((ForgeToolExecutor)project.getObjects().newInstance(ForgeToolExecutor.class, new Object[0])).exec(settings);
    }

    private ExecResult exec(Settings settings) {
        return ForgeToolExecutor.exec(this.getExecOperations(), settings);
    }

    public static ExecResult exec(ExecOperations execOperations, Settings settings) {
        return execOperations.javaexec(spec -> {
            @Nullable String executable = (String)settings.getExecutable().getOrNull();
            if (executable != null) {
                spec.setExecutable(executable);
            }
            spec.getMainClass().set(settings.getMainClass());
            spec.setArgs((List)settings.getProgramArgs().get());
            spec.setJvmArgs((List)settings.getJvmArgs().get());
            spec.setClasspath((FileCollection)settings.getExecClasspath());
            if (((Boolean)settings.getShowVerboseStdout().get()).booleanValue()) {
                spec.setStandardOutput((OutputStream)System.out);
            } else {
                spec.setStandardOutput((OutputStream)NullOutputStream.INSTANCE);
            }
            if (((Boolean)settings.getShowVerboseStderr().get()).booleanValue()) {
                spec.setErrorOutput((OutputStream)System.err);
            } else {
                spec.setErrorOutput((OutputStream)NullOutputStream.INSTANCE);
            }
        });
    }

    public static interface Settings {
        @Input
        public Property<String> getExecutable();

        @Input
        public ListProperty<String> getProgramArgs();

        @Input
        public ListProperty<String> getJvmArgs();

        @Input
        public Property<String> getMainClass();

        @Classpath
        public ConfigurableFileCollection getExecClasspath();

        @Input
        public Property<Boolean> getShowVerboseStdout();

        @Input
        public Property<Boolean> getShowVerboseStderr();

        default public void classpath(Object ... paths) {
            this.getExecClasspath().from(paths);
        }

        default public void setClasspath(Object ... paths) {
            this.getExecClasspath().setFrom(paths);
        }

        default public void args(String ... args) {
            this.getProgramArgs().addAll((Object[])args);
        }

        default public void args(Collection<String> args) {
            this.getProgramArgs().addAll(args);
        }

        default public void setArgs(List<String> args) {
            this.getProgramArgs().set(args);
        }

        default public void jvmArgs(String ... args) {
            this.getJvmArgs().addAll((Object[])args);
        }

        default public void jvmArgs(Collection<String> args) {
            this.getJvmArgs().addAll(args);
        }
    }
}

