/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;

public final class FabricModJsonUtils {
    private FabricModJsonUtils() {
    }

    public static String readString(JsonObject jsonObject, String key) {
        JsonElement element = FabricModJsonUtils.getElement(jsonObject, key);
        FabricModJsonUtils.ensurePrimitive(element, JsonPrimitive::isString, key);
        return element.getAsString();
    }

    public static int readInt(JsonObject jsonObject, String key) {
        JsonElement element = FabricModJsonUtils.getElement(jsonObject, key);
        FabricModJsonUtils.ensurePrimitive(element, JsonPrimitive::isNumber, key);
        return element.getAsInt();
    }

    public static JsonObject getJsonObject(JsonObject jsonObject, String key) {
        JsonElement element = FabricModJsonUtils.getElement(jsonObject, key);
        if (!element.isJsonObject()) {
            throw new ParseException("Unexpected json object type for key (%s)", key);
        }
        return element.getAsJsonObject();
    }

    public static JsonObject optimizeFmj(JsonObject json) {
        if (!json.has("schemaVersion")) {
            return json;
        }
        JsonObject out = new JsonObject();
        out.add("schemaVersion", json.get("schemaVersion"));
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).equals("schemaVersion")) continue;
            out.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return out;
    }

    private static JsonElement getElement(JsonObject jsonObject, String key) {
        JsonElement element = jsonObject.get(key);
        if (element == null) {
            throw new ParseException("Unable to find json element for key (%s)", key);
        }
        return element;
    }

    private static void ensurePrimitive(JsonElement jsonElement, Predicate<JsonPrimitive> predicate, String key) {
        if (!jsonElement.isJsonPrimitive() || !predicate.test(jsonElement.getAsJsonPrimitive())) {
            throw new ParseException("Unexpected primitive type for key (%s)", key);
        }
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String message, Object ... args) {
            super(String.format(Locale.ROOT, message, args));
        }
    }
}

