/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.forge.DependencyProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;

public class DependencyProviders {
    private final List<DependencyProvider> dependencyProviderList = new ArrayList<DependencyProvider>();

    public <T extends DependencyProvider> T addProvider(T provider) {
        if (this.dependencyProviderList.contains(provider)) {
            throw new RuntimeException("Provider is already registered");
        }
        if (this.getProvider(provider.getClass()) != null) {
            throw new RuntimeException("Provider of this type is already registered");
        }
        this.dependencyProviderList.add(provider);
        return provider;
    }

    public <T> T getProvider(Class<T> clazz) {
        for (DependencyProvider provider : this.dependencyProviderList) {
            if (provider.getClass() != clazz) continue;
            return (T)provider;
        }
        return null;
    }

    public void handleDependencies(Project project) {
        ArrayList afterTasks = new ArrayList();
        project.getLogger().info(":setting up loom dependencies");
        HashMap<String, ProviderList> providerListMap = new HashMap<String, ProviderList>();
        ArrayList targetProviders = new ArrayList();
        for (DependencyProvider provider : this.dependencyProviderList) {
            providerListMap.computeIfAbsent(provider.getTargetConfig(), (Function<String, ProviderList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handleDependencies$0(java.util.List java.lang.String ), (Ljava/lang/String;)Lnet/fabricmc/loom/configuration/providers/forge/DependencyProviders$ProviderList;)(targetProviders)).providers.add(provider);
        }
        for (ProviderList list : targetProviders) {
            Configuration configuration = project.getConfigurations().getByName(list.key);
            DependencySet dependencies = configuration.getDependencies();
            if (dependencies.isEmpty()) {
                throw new IllegalArgumentException(String.format("No '%s' dependency was specified!", list.key));
            }
            if (dependencies.size() > 1) {
                throw new IllegalArgumentException(String.format("Only one '%s' dependency should be specified, but %d were!", list.key, dependencies.size()));
            }
            for (Dependency dependency : dependencies) {
                for (DependencyProvider provider : list.providers) {
                    DependencyInfo info = DependencyInfo.create(project, dependency, configuration);
                    try {
                        provider.provide(info);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to provide " + dependency.getGroup() + ":" + dependency.getName() + ":" + dependency.getVersion() + " : " + e.toString(), e);
                    }
                }
            }
        }
        for (Runnable runnable : afterTasks) {
            runnable.run();
        }
    }

    private static /* synthetic */ ProviderList lambda$handleDependencies$0(List targetProviders, String k) {
        ProviderList list = new ProviderList(k);
        targetProviders.add(list);
        return list;
    }

    private static class ProviderList {
        private final String key;
        private final List<DependencyProvider> providers = new ArrayList<DependencyProvider>();

        ProviderList(String key) {
            this.key = key;
        }
    }
}

