/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.mods.ArtifactMetadata;
import net.fabricmc.loom.configuration.mods.dependency.ModDependency;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.service.ServiceFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Usage;

public class ModProcessor {
    private static final String toM = MappingsNamespace.NAMED.toString();
    private static final Pattern COPY_CONFIGURATION_PATTERN = Pattern.compile("^(.+)Copy[0-9]*$");
    private final Project project;
    private final Configuration sourceConfiguration;
    private final ServiceFactory serviceFactory;

    public ModProcessor(Project project, Configuration sourceConfiguration, ServiceFactory serviceFactory) {
        this.project = project;
        this.sourceConfiguration = sourceConfiguration;
        this.serviceFactory = serviceFactory;
    }

    public void processMods(List<ModDependency> remapList) throws IOException {
        try {
            this.project.getLogger().lifecycle(":remapping {} mods from {}", new Object[]{remapList.size(), this.describeConfiguration(this.sourceConfiguration)});
            this.remapJars(remapList);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to remap %d mods", remapList.size()), e);
        }
    }

    private String describeConfiguration(Configuration configuration) {
        Usage usage;
        Object description = configuration.getName();
        Matcher copyMatcher = COPY_CONFIGURATION_PATTERN.matcher((CharSequence)description);
        if (copyMatcher.matches()) {
            String realName = copyMatcher.group(1);
            if (this.project.getConfigurations().findByName(realName) != null) {
                description = realName;
            }
        }
        if ((usage = (Usage)configuration.getAttributes().getAttribute(Usage.USAGE_ATTRIBUTE)) != null) {
            description = (String)description + " (" + usage.getName() + ")";
        }
        return description;
    }

    private void stripNestedJars(Path path) {
        try {
            ZipUtils.deleteIfExists(path, "META-INF/jarjar/metadata.json");
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to strip nested jars from %s".formatted(path), e);
        }
        if (!ZipUtils.contains(path, "fabric.mod.json")) {
            if (ZipUtils.contains(path, "quilt.mod.json")) {
                try {
                    ZipUtils.transformJson(JsonObject.class, path, Map.of("quilt.mod.json", json -> {
                        if (json.has("quilt_loader")) {
                            json.getAsJsonObject("quilt_loader").remove("jars");
                        }
                        return json;
                    }));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to strip nested jars from %s".formatted(path), e);
                }
            }
            return;
        }
        try {
            ZipUtils.transformJson(JsonObject.class, path, Map.of("fabric.mod.json", json -> {
                json.remove("jars");
                return json;
            }));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to strip nested jars from %s".formatted(path), e);
        }
    }

    /*
     * Exception decompiling
     */
    private void remapJars(List<ModDependency> remapList) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Path getRemappedOutput(ModDependency dependency) {
        return dependency.getWorkingFile(null);
    }

    private void remapJarManifestEntries(Path jar) throws IOException {
        ZipUtils.transform(jar, Map.of("META-INF/MANIFEST.MF", bytes -> {
            Manifest manifest = new Manifest(new ByteArrayInputStream((byte[])bytes));
            manifest.getMainAttributes().putValue("Fabric-Mapping-Namespace", toM);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            manifest.write(out);
            return out.toByteArray();
        }));
    }

    private static /* synthetic */ boolean lambda$remapJars$4(File inputFile, ModDependency info) {
        return info.getInputFile().toFile().equals(inputFile);
    }

    private static /* synthetic */ Path[] lambda$remapJars$3(int x$0) {
        return new Path[x$0];
    }

    private static /* synthetic */ boolean lambda$remapJars$2(ModDependency modDependency) {
        return modDependency.getMetadata().mixinRemapType() == ArtifactMetadata.MixinRemapType.STATIC;
    }
}

