/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.library;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loom.configuration.providers.BundleMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.configuration.providers.minecraft.library.Library;
import net.fabricmc.loom.util.Platform;

public class MinecraftLibraryHelper {
    private static final Pattern NATIVES_PATTERN = Pattern.compile("^(?<group>.*)/(.*?)/(?<version>.*)/((?<name>.*?)-(\\k<version>)-)(?<classifier>.*).jar$");

    public static List<Library> getLibrariesForPlatform(MinecraftVersionMeta versionMeta, Platform platform) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (MinecraftVersionMeta.Library library : versionMeta.libraries()) {
            MinecraftVersionMeta.Download download;
            if (!library.isValidForOS(platform)) continue;
            if (library.artifact() != null) {
                Library mavenLib = Library.fromMaven(library.name(), Library.Target.COMPILE);
                if (mavenLib.classifier() != null && mavenLib.classifier().startsWith("natives-")) {
                    mavenLib = mavenLib.withTarget(Library.Target.NATIVES);
                }
                libraries.add(mavenLib);
            }
            if (!library.hasNativesForOS(platform) || (download = library.classifierForOS(platform)) == null) continue;
            libraries.add(MinecraftLibraryHelper.downloadToLibrary(download));
        }
        return Collections.unmodifiableList(libraries);
    }

    private static Library downloadToLibrary(MinecraftVersionMeta.Download download) {
        String path = download.path();
        Matcher matcher = NATIVES_PATTERN.matcher(path);
        if (!matcher.find()) {
            throw new IllegalStateException("Failed to match regex for natives path : " + path);
        }
        String group = matcher.group("group").replace("/", ".");
        String name = matcher.group("name");
        String version = matcher.group("version");
        String classifier = matcher.group("classifier");
        String dependencyNotation = "%s:%s:%s:%s".formatted(group, name, version, classifier);
        return Library.fromMaven(dependencyNotation, Library.Target.NATIVES);
    }

    public static List<Library> getServerLibraries(BundleMetadata bundleMetadata) {
        Objects.requireNonNull(bundleMetadata);
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (BundleMetadata.Entry library : bundleMetadata.libraries()) {
            libraries.add(Library.fromMaven(library.name(), Library.Target.COMPILE));
        }
        return libraries;
    }
}

