/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.fabricmc.loom.util.FileSystemUtil;

public class MinecraftJarSplitter
implements AutoCloseable {
    private final Path clientInputJar;
    private final Path serverInputJar;
    private EntryData entryData;
    private Set<String> sharedEntries = new HashSet<String>();
    private Set<String> forcedClientEntries = new HashSet<String>();

    public MinecraftJarSplitter(Path clientInputJar, Path serverInputJar) {
        this.clientInputJar = Objects.requireNonNull(clientInputJar);
        this.serverInputJar = Objects.requireNonNull(serverInputJar);
    }

    public void split(Path clientOnlyOutputJar, Path commonOutputJar) throws IOException {
        Objects.requireNonNull(clientOnlyOutputJar);
        Objects.requireNonNull(commonOutputJar);
        if (this.entryData == null) {
            this.entryData = new EntryData(MinecraftJarSplitter.getJarEntries(this.clientInputJar), MinecraftJarSplitter.getJarEntries(this.serverInputJar));
        }
        assert (this.entryData.serverOnlyEntries.isEmpty());
        this.copyEntriesToJar(this.entryData.commonEntries, this.serverInputJar, commonOutputJar, "common");
        this.copyEntriesToJar(this.entryData.clientOnlyEntries, this.clientInputJar, clientOnlyOutputJar, "client");
    }

    public void sharedEntry(String path) {
        this.sharedEntries.add(path);
    }

    public void forcedClientEntry(String path) {
        this.forcedClientEntries.add(path);
    }

    public static Set<String> getJarEntries(Path input) throws IOException {
        HashSet entries = Sets.newHashSet();
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(input);
             Stream<Path> walk = Files.walk(fs.get().getPath("/", new String[0]), new FileVisitOption[0]);){
            Iterator iterator = walk.iterator();
            while (iterator.hasNext()) {
                String entryPath;
                Path fsPath = (Path)iterator.next();
                if (!Files.isRegularFile(fsPath, new LinkOption[0]) || (entryPath = fs.get().getPath("/", new String[0]).relativize(fsPath).toString()).startsWith("META-INF/")) continue;
                entries.add(entryPath);
            }
        }
        return entries;
    }

    private void copyEntriesToJar(Set<String> entries, Path inputJar, Path outputJar, String env) throws IOException {
        Files.deleteIfExists(outputJar);
        try (FileSystemUtil.Delegate inputFs = FileSystemUtil.getJarFileSystem(inputJar);
             FileSystemUtil.Delegate outputFs = FileSystemUtil.getJarFileSystem(outputJar, true);){
            for (String entry : entries) {
                Path inputPath = inputFs.get().getPath(entry, new String[0]);
                Path outputPath = outputFs.get().getPath(entry, new String[0]);
                assert (Files.isRegularFile(inputPath, new LinkOption[0]));
                Path outputPathParent = outputPath.getParent();
                if (outputPathParent != null) {
                    Files.createDirectories(outputPathParent, new FileAttribute[0]);
                }
                Files.copy(inputPath, outputPath, StandardCopyOption.COPY_ATTRIBUTES);
            }
            this.writeManifest(outputFs, env);
        }
    }

    private void writeManifest(FileSystemUtil.Delegate outputFs, String env) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().putValue("Fabric-Loom-Split-Environment-Name", env);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        manifest.write(out);
        Files.createDirectories(outputFs.get().getPath("META-INF", new String[0]), new FileAttribute[0]);
        Files.write(outputFs.get().getPath("META-INF/MANIFEST.MF", new String[0]), out.toByteArray(), new OpenOption[0]);
    }

    @Override
    public void close() throws Exception {
    }

    private final class EntryData {
        private final Set<String> clientEntries;
        private final Set<String> serverEntries;
        private final Set<String> commonEntries;
        private final Set<String> clientOnlyEntries;
        private final Set<String> serverOnlyEntries;

        private EntryData(Set<String> clientEntries, Set<String> serverEntries) {
            this.clientEntries = clientEntries;
            this.serverEntries = serverEntries;
            this.commonEntries = Sets.newHashSet(clientEntries);
            this.commonEntries.retainAll(serverEntries);
            this.commonEntries.addAll(MinecraftJarSplitter.this.sharedEntries);
            this.commonEntries.removeAll(MinecraftJarSplitter.this.forcedClientEntries);
            this.clientOnlyEntries = Sets.newHashSet(clientEntries);
            this.clientOnlyEntries.removeAll(serverEntries);
            this.clientOnlyEntries.addAll(MinecraftJarSplitter.this.sharedEntries);
            this.clientOnlyEntries.addAll(MinecraftJarSplitter.this.forcedClientEntries);
            this.serverOnlyEntries = Sets.newHashSet(serverEntries);
            this.serverOnlyEntries.removeAll(clientEntries);
        }
    }
}

