/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.IMappingProvider;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;

public final class MappingsService
extends Service<Options>
implements Closeable {
    public static ServiceType<Options, MappingsService> TYPE = new ServiceType<Options, MappingsService>(Options.class, MappingsService.class);
    private IMappingProvider mappingProvider = null;
    private MemoryMappingTree memoryMappingTree = null;

    public static Provider<Options> createOptions(Project project, Path mappingsFile, String from, String to, boolean remapLocals) {
        return MappingsService.createOptions(project, mappingsFile, (Provider<String>)project.provider(() -> from), (Provider<String>)project.provider(() -> to), remapLocals);
    }

    public static Provider<Options> createOptions(Project project, Path mappingsFile, Provider<String> from, Provider<String> to, boolean remapLocals) {
        return TYPE.create(project, (Action<Options>)((Action)o -> {
            o.getMappingsFile().set(mappingsFile.toFile());
            o.getFrom().set(from);
            o.getTo().set(to);
            o.getRemapLocals().set((Object)remapLocals);
        }));
    }

    public static Provider<Options> createOptionsWithProjectMappings(Project project, Provider<String> from, Provider<String> to) {
        MappingConfiguration mappingConfiguration = LoomGradleExtension.get(project).getMappingConfiguration();
        return MappingsService.createOptions(project, LoomGradleExtension.get(project).getPlatformMappingFile(), from, to, false);
    }

    public MappingsService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public IMappingProvider getMappingsProvider() {
        if (this.mappingProvider == null) {
            try {
                this.mappingProvider = TinyRemapperHelper.create(this.getMappingsPath(), this.getFrom(), this.getTo(), (boolean)((Boolean)((Options)this.getOptions()).getRemapLocals().get()));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read mappings from: " + String.valueOf(this.getMappingsPath()), e);
            }
        }
        return this.mappingProvider;
    }

    public MemoryMappingTree getMemoryMappingTree() {
        if (this.memoryMappingTree == null) {
            this.memoryMappingTree = new MemoryMappingTree();
            try {
                MappingReader.read((Path)this.getMappingsPath(), (MappingVisitor)this.memoryMappingTree);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read mappings from: " + String.valueOf(this.getMappingsPath()), e);
            }
        }
        return this.memoryMappingTree;
    }

    public String getFrom() {
        return (String)((Options)this.getOptions()).getFrom().get();
    }

    public String getTo() {
        return (String)((Options)this.getOptions()).getTo().get();
    }

    public Path getMappingsPath() {
        return ((RegularFile)((Options)this.getOptions()).getMappingsFile().get()).getAsFile().toPath();
    }

    @Override
    public void close() {
        this.mappingProvider = null;
    }

    public static interface Options
    extends Service.Options {
        @InputFile
        public RegularFileProperty getMappingsFile();

        @Input
        public Property<String> getFrom();

        @Input
        public Property<String> getTo();

        @Input
        public Property<Boolean> getRemapLocals();
    }
}

