/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.RemapConfigurations;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.task.AbstractRemapJarTask;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.jvm.tasks.Jar;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MinecraftSourceSets {
    public static MinecraftSourceSets get(Project project) {
        return LoomGradleExtension.get(project).areEnvironmentSourceSetsSplit() ? Split.INSTANCE : Single.INSTANCE;
    }

    public abstract void applyDependencies(BiConsumer<String, MinecraftJar.Type> var1, List<MinecraftJar.Type> var2);

    public abstract String getSourceSetForEnv(String var1);

    protected abstract List<ConfigurationName> getConfigurations();

    public void evaluateSplit(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Preconditions.checkArgument((boolean)extension.areEnvironmentSourceSetsSplit());
        Split.INSTANCE.evaluate(project);
    }

    public abstract void afterEvaluate(Project var1);

    protected void createConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        for (ConfigurationName configurationName : this.getConfigurations()) {
            configurations.register(configurationName.runtime(), configuration -> {
                configuration.setTransitive(false);
                configuration.extendsFrom(new Configuration[]{configurations.getByName(configurationName.mcLibsRuntimeName())});
                configuration.extendsFrom(new Configuration[]{configurations.getByName("loaderLibraries")});
                configuration.extendsFrom(new Configuration[]{configurations.getByName("loomDevelopmentDependencies")});
                if (LoomGradleExtension.get(project).isForgeLike()) {
                    configurations.getByName("forgeRuntimeLibrary").extendsFrom(new Configuration[]{configuration});
                }
            });
            configurations.register(configurationName.compile(), configuration -> {
                configuration.setTransitive(false);
                configuration.extendsFrom(new Configuration[]{configurations.getByName(configurationName.mcLibsCompileName())});
                configuration.extendsFrom(new Configuration[]{configurations.getByName("loaderLibraries")});
            });
        }
    }

    protected void extendsFrom(Project project, String name, String extendsFrom) {
        ConfigurationContainer configurations = project.getConfigurations();
        configurations.named(name, configuration -> configuration.extendsFrom(new Configuration[]{configurations.getByName(extendsFrom)}));
    }

    public static final class Split
    extends MinecraftSourceSets {
        private static final ConfigurationName MINECRAFT_COMMON_NAMED = new ConfigurationName("minecraftCommonNamed", "minecraftLibraries", "minecraftRuntimeLibraries");
        private static final ConfigurationName MINECRAFT_CLIENT_ONLY_NAMED = new ConfigurationName("minecraftClientOnlyNamed", "minecraftClientLibraries", "minecraftClientRuntimeLibraries");
        public static final String CLIENT_ONLY_SOURCE_SET_NAME = "client";
        private static final Split INSTANCE = new Split();

        @Override
        public void applyDependencies(BiConsumer<String, MinecraftJar.Type> consumer, List<MinecraftJar.Type> targets) {
            Preconditions.checkArgument((targets.size() == 2 ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)targets.contains((Object)MinecraftJar.Type.COMMON));
            Preconditions.checkArgument((boolean)targets.contains((Object)MinecraftJar.Type.CLIENT_ONLY));
            consumer.accept(MINECRAFT_COMMON_NAMED.runtime(), MinecraftJar.Type.COMMON);
            consumer.accept(MINECRAFT_CLIENT_ONLY_NAMED.runtime(), MinecraftJar.Type.CLIENT_ONLY);
            consumer.accept(MINECRAFT_COMMON_NAMED.compile(), MinecraftJar.Type.COMMON);
            consumer.accept(MINECRAFT_CLIENT_ONLY_NAMED.compile(), MinecraftJar.Type.CLIENT_ONLY);
        }

        @Override
        public String getSourceSetForEnv(String env) {
            return env.equals(CLIENT_ONLY_SOURCE_SET_NAME) ? CLIENT_ONLY_SOURCE_SET_NAME : "main";
        }

        @Override
        protected List<ConfigurationName> getConfigurations() {
            return List.of(MINECRAFT_COMMON_NAMED, MINECRAFT_CLIENT_ONLY_NAMED);
        }

        private void evaluate(Project project) {
            this.createConfigurations(project);
            ConfigurationContainer configurations = project.getConfigurations();
            SourceSet mainSourceSet = SourceSetHelper.getMainSourceSet(project);
            SourceSet clientOnlySourceSet = SourceSetHelper.createSourceSet(CLIENT_ONLY_SOURCE_SET_NAME, project);
            this.extendsFrom(project, mainSourceSet.getCompileClasspathConfigurationName(), MINECRAFT_COMMON_NAMED.compile());
            this.extendsFrom(project, mainSourceSet.getRuntimeClasspathConfigurationName(), MINECRAFT_COMMON_NAMED.runtime());
            this.extendsFrom(project, clientOnlySourceSet.getCompileClasspathConfigurationName(), MINECRAFT_CLIENT_ONLY_NAMED.compile());
            this.extendsFrom(project, clientOnlySourceSet.getRuntimeClasspathConfigurationName(), MINECRAFT_CLIENT_ONLY_NAMED.runtime());
            this.extendsFrom(project, MINECRAFT_CLIENT_ONLY_NAMED.runtime(), MINECRAFT_COMMON_NAMED.runtime());
            this.extendsFrom(project, MINECRAFT_CLIENT_ONLY_NAMED.compile(), MINECRAFT_COMMON_NAMED.compile());
            this.extendsFrom(project, clientOnlySourceSet.getAnnotationProcessorConfigurationName(), "annotationProcessor");
            clientOnlySourceSet.setCompileClasspath(clientOnlySourceSet.getCompileClasspath().plus((FileCollection)mainSourceSet.getOutput()));
            clientOnlySourceSet.setRuntimeClasspath(clientOnlySourceSet.getRuntimeClasspath().plus((FileCollection)mainSourceSet.getOutput()));
            this.extendsFrom(project, clientOnlySourceSet.getCompileClasspathConfigurationName(), mainSourceSet.getCompileClasspathConfigurationName());
            this.extendsFrom(project, clientOnlySourceSet.getRuntimeClasspathConfigurationName(), mainSourceSet.getRuntimeClasspathConfigurationName());
            SourceSet testSourceSet = SourceSetHelper.getSourceSetByName("test", project);
            this.extendsFrom(project, testSourceSet.getCompileClasspathConfigurationName(), clientOnlySourceSet.getCompileClasspathConfigurationName());
            this.extendsFrom(project, testSourceSet.getRuntimeClasspathConfigurationName(), clientOnlySourceSet.getRuntimeClasspathConfigurationName());
            project.getDependencies().add(testSourceSet.getImplementationConfigurationName(), (Object)clientOnlySourceSet.getOutput());
            RemapConfigurations.configureClientConfigurations(project, clientOnlySourceSet);
            project.getTasks().named(mainSourceSet.getJarTaskName(), Jar.class).configure(jar -> {
                jar.from(new Object[]{clientOnlySourceSet.getOutput().getClassesDirs()});
                jar.from(new Object[]{clientOnlySourceSet.getOutput().getResourcesDir()});
                jar.dependsOn(new Object[]{project.getTasks().named(clientOnlySourceSet.getProcessResourcesTaskName())});
            });
            project.getTasks().withType(AbstractRemapJarTask.class).configureEach(remapJarTask -> remapJarTask.getClasspath().from(new Object[]{project.getConfigurations().getByName(clientOnlySourceSet.getCompileClasspathConfigurationName())}));
            project.getTasks().configureEach(task -> {
                if (!mainSourceSet.getSourcesJarTaskName().equals(task.getName()) || !(task instanceof Jar)) {
                    return;
                }
                Jar jar = (Jar)task;
                jar.from(new Object[]{clientOnlySourceSet.getAllSource()});
            });
            project.getTasks().withType(AbstractRemapJarTask.class, task -> task.getClientOnlySourceSetName().convention((Object)CLIENT_ONLY_SOURCE_SET_NAME));
        }

        @Override
        public void afterEvaluate(Project project) {
        }
    }

    public static final class Single
    extends MinecraftSourceSets {
        private static final ConfigurationName MINECRAFT_NAMED = new ConfigurationName("minecraftNamed", "minecraftLibraries", "minecraftRuntimeLibraries");
        private static final Single INSTANCE = new Single();

        @Override
        public void applyDependencies(BiConsumer<String, MinecraftJar.Type> consumer, List<MinecraftJar.Type> targets) {
            for (MinecraftJar.Type target : targets) {
                consumer.accept(MINECRAFT_NAMED.compile(), target);
                consumer.accept(MINECRAFT_NAMED.runtime(), target);
            }
        }

        @Override
        public String getSourceSetForEnv(String env) {
            return "main";
        }

        @Override
        protected List<ConfigurationName> getConfigurations() {
            return List.of(MINECRAFT_NAMED);
        }

        @Override
        public void afterEvaluate(Project project) {
            this.createConfigurations(project);
            this.extendsFrom(project, "compileClasspath", MINECRAFT_NAMED.compile());
            this.extendsFrom(project, "runtimeClasspath", MINECRAFT_NAMED.runtime());
            this.extendsFrom(project, "testCompileClasspath", MINECRAFT_NAMED.compile());
            this.extendsFrom(project, "testRuntimeClasspath", MINECRAFT_NAMED.runtime());
        }
    }

    private record ConfigurationName(String baseName, String mcLibsCompileName, String mcLibsRuntimeName) {
        private String runtime() {
            return this.baseName + "Runtime";
        }

        private String compile() {
            return this.baseName + "Compile";
        }
    }
}

