/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods.dependency;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.ModSettings;
import net.fabricmc.loom.configuration.mods.ArtifactMetadata;
import net.fabricmc.loom.configuration.mods.ArtifactRef;
import net.fabricmc.loom.configuration.mods.JarSplitter;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.mods.dependency.ModDependency;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.jetbrains.annotations.Nullable;

public final class SplitModDependency
extends ModDependency {
    private final Configuration targetCommonConfig;
    private final Configuration targetClientConfig;
    private final JarSplitter.Target target;
    @Nullable
    private final LocalMavenHelper commonMaven;
    @Nullable
    private final LocalMavenHelper clientMaven;

    public SplitModDependency(ArtifactRef artifact, ArtifactMetadata metadata, String mappingsSuffix, Configuration targetCommonConfig, Configuration targetClientConfig, JarSplitter.Target target, Project project) {
        super(artifact, metadata, mappingsSuffix, project);
        this.targetCommonConfig = Objects.requireNonNull(targetCommonConfig);
        this.targetClientConfig = Objects.requireNonNull(targetClientConfig);
        this.target = Objects.requireNonNull(target);
        this.commonMaven = target.common() ? this.createMaven(this.name + "-common") : null;
        this.clientMaven = target.client() ? this.createMaven(this.name + "-client") : null;
    }

    @Override
    public boolean isCacheInvalid(Project project, @Nullable String variant) {
        boolean exists = switch (this.target) {
            default -> throw new IncompatibleClassChangeError();
            case JarSplitter.Target.COMMON_ONLY -> this.getCommonMaven().exists(variant);
            case JarSplitter.Target.CLIENT_ONLY -> this.getClientMaven().exists(variant);
            case JarSplitter.Target.SPLIT -> this.getCommonMaven().exists(variant) && this.getClientMaven().exists(variant);
        };
        return !exists;
    }

    @Override
    public void copyToCache(Project project, Path path, @Nullable String variant) throws IOException {
        JarSplitter.Target artifactTarget;
        if (this.target == JarSplitter.Target.SPLIT && variant != null && (artifactTarget = new JarSplitter(path).analyseTarget()) != this.target) {
            this.getCommonMaven().copyToMaven(path, variant);
            this.getClientMaven().copyToMaven(path, variant);
            return;
        }
        switch (this.target) {
            case SPLIT: {
                Object suffix = variant == null ? "" : "-" + variant;
                Path commonTempJar = this.getWorkingFile("common" + (String)suffix);
                Path clientTempJar = this.getWorkingFile("client" + (String)suffix);
                JarSplitter splitter = new JarSplitter(path);
                splitter.split(commonTempJar, clientTempJar);
                this.getCommonMaven().copyToMaven(commonTempJar, variant);
                this.getClientMaven().copyToMaven(clientTempJar, variant);
                break;
            }
            case CLIENT_ONLY: {
                this.getClientMaven().copyToMaven(path, variant);
                break;
            }
            case COMMON_ONLY: {
                this.getCommonMaven().copyToMaven(path, variant);
            }
        }
    }

    @Override
    public void applyToProject(Project project) {
        if (this.target.common()) {
            project.getDependencies().add(this.targetCommonConfig.getName(), (Object)this.getCommonMaven().getNotation());
        }
        if (this.target.client()) {
            project.getDependencies().add(this.targetClientConfig.getName(), (Object)this.getClientMaven().getNotation());
        }
        if (this.target == JarSplitter.Target.SPLIT) {
            this.createModGroup(this.getCommonMaven().getOutputFile(null), this.getClientMaven().getOutputFile(null));
        }
    }

    private void createModGroup(Path commonJar, Path clientJar) {
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        ModSettings modSettings = (ModSettings)extension.getMods().maybeCreate(String.format("%s-%s-%s", this.getRemappedGroup(), this.name, this.version));
        modSettings.getModFiles().from(new Object[]{commonJar.toFile(), clientJar.toFile()});
    }

    public LocalMavenHelper getCommonMaven() {
        return Objects.requireNonNull(this.commonMaven, "Cannot get null common maven helper");
    }

    public LocalMavenHelper getClientMaven() {
        return Objects.requireNonNull(this.clientMaven, "Cannot get null client maven helper");
    }
}

