/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.service;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.loom.util.gradle.GradleTypeAdapter;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;

public final class ScopedServiceFactory
implements ServiceFactory,
Closeable {
    private final Map<Service.Options, Service<?>> servicesIdentityMap = new IdentityHashMap();
    private final Map<String, Service<?>> servicesJsonMap = new HashMap();

    @Override
    public <O extends Service.Options, S extends Service<O>> S get(O options) {
        Service<Object> service = this.servicesIdentityMap.get(options);
        if (service != null) {
            return (S)service;
        }
        String key = this.getOptionsCacheKey(options);
        service = this.servicesJsonMap.get(key);
        if (service != null) {
            return (S)service;
        }
        service = ScopedServiceFactory.createService(options, this);
        this.servicesIdentityMap.put(options, service);
        this.servicesJsonMap.put(key, service);
        return (S)service;
    }

    private static <O extends Service.Options, S extends Service<O>> S createService(O options, ServiceFactory serviceFactory) {
        Class<?> serviceClass;
        try {
            serviceClass = Class.forName((String)options.getServiceClass().get());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to find service class: " + (String)options.getServiceClass().get(), e);
        }
        try {
            if (serviceClass.getDeclaredConstructors().length != 1) {
                throw new RuntimeException("Service class must have exactly 1 constructor");
            }
            Class<?>[] parameterTypes = serviceClass.getDeclaredConstructors()[0].getParameterTypes();
            if (parameterTypes.length != 2 || !parameterTypes[0].isAssignableFrom(options.getClass()) || !parameterTypes[1].isAssignableFrom(ServiceFactory.class)) {
                throw new RuntimeException("Service class" + serviceClass.getName() + " constructor must take the options class and a ScopedServiceFactory");
            }
            return (S)((Service)serviceClass.getDeclaredConstructors()[0].newInstance(options, serviceFactory));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create service instance", e);
        }
    }

    private String getOptionsCacheKey(Service.Options options) {
        return GradleTypeAdapter.GSON.toJson((Object)options);
    }

    @Override
    public void close() throws IOException {
        for (Service<?> service : this.servicesIdentityMap.values()) {
            if (!(service instanceof Closeable)) continue;
            Closeable closeable = (Closeable)((Object)service);
            closeable.close();
        }
        this.servicesIdentityMap.clear();
        this.servicesJsonMap.clear();
    }
}

