/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.providers.BundleMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarSplitter;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftMetadataProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;

public final class SplitMinecraftProvider
extends MinecraftProvider {
    private Path minecraftClientOnlyJar;
    private Path minecraftCommonJar;

    public SplitMinecraftProvider(MinecraftMetadataProvider metadataProvider, ConfigContext configContext) {
        super(metadataProvider, configContext);
    }

    @Override
    protected void initFiles() {
        super.initFiles();
        this.minecraftClientOnlyJar = this.path("minecraft-client-only.jar");
        this.minecraftCommonJar = this.path("minecraft-common.jar");
    }

    @Override
    public List<Path> getMinecraftJars() {
        return List.of(this.minecraftClientOnlyJar, this.minecraftCommonJar);
    }

    @Override
    public MappingsNamespace getOfficialNamespace() {
        return MappingsNamespace.OFFICIAL;
    }

    @Override
    public void provide() throws Exception {
        boolean requiresRefresh;
        super.provide();
        boolean bl = requiresRefresh = this.getExtension().refreshDeps() || Files.notExists(this.minecraftClientOnlyJar, new LinkOption[0]) || Files.notExists(this.minecraftCommonJar, new LinkOption[0]);
        if (!requiresRefresh) {
            return;
        }
        BundleMetadata serverBundleMetadata = this.getServerBundleMetadata();
        if (serverBundleMetadata == null) {
            throw new UnsupportedOperationException("Only Minecraft versions using a bundled server jar can be split, please use a merged jar setup for this version of minecraft");
        }
        this.extractBundledServerJar();
        Path clientJar = this.getMinecraftClientJar().toPath();
        Path serverJar = this.getMinecraftExtractedServerJar().toPath();
        try (MinecraftJarSplitter jarSplitter = new MinecraftJarSplitter(clientJar, serverJar);){
            jarSplitter.sharedEntry("version.json");
            jarSplitter.sharedEntry("assets/.mcassetsroot");
            jarSplitter.sharedEntry("assets/minecraft/lang/en_us.json");
            jarSplitter.split(this.minecraftClientOnlyJar, this.minecraftCommonJar);
        }
        catch (Exception e) {
            Files.deleteIfExists(this.minecraftClientOnlyJar);
            Files.deleteIfExists(this.minecraftCommonJar);
            throw new RuntimeException("Failed to split minecraft", e);
        }
    }

    public Path getMinecraftClientOnlyJar() {
        return this.minecraftClientOnlyJar;
    }

    public Path getMinecraftCommonJar() {
        return this.minecraftCommonJar;
    }
}

