/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MinecraftJar {
    private final Path path;
    private final boolean merged;
    private final boolean client;
    private final boolean server;
    private final Type type;

    protected MinecraftJar(Path path, boolean merged, boolean client, boolean server, Type type) {
        this.path = Objects.requireNonNull(path);
        this.merged = merged;
        this.client = client;
        this.server = server;
        this.type = type;
    }

    public Path getPath() {
        return this.path;
    }

    public File toFile() {
        return this.getPath().toFile();
    }

    public boolean isMerged() {
        return this.merged;
    }

    public boolean includesClient() {
        return this.client;
    }

    public boolean includesServer() {
        return this.server;
    }

    public String getName() {
        return this.type.toString();
    }

    public Type getType() {
        return this.type;
    }

    public abstract MinecraftJar forPath(Path var1);

    public static enum Type {
        MERGED("merged"),
        SERVER("server"),
        CLIENT("client"),
        COMMON("common"),
        CLIENT_ONLY("clientOnly");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class ClientOnly
    extends MinecraftJar {
        public ClientOnly(Path path) {
            super(path, false, true, false, Type.CLIENT_ONLY);
        }

        @Override
        public MinecraftJar forPath(Path path) {
            return new ClientOnly(path);
        }
    }

    public static final class Client
    extends MinecraftJar {
        public Client(Path path) {
            super(path, false, true, false, Type.CLIENT);
        }

        @Override
        public MinecraftJar forPath(Path path) {
            return new Client(path);
        }
    }

    public static final class Server
    extends MinecraftJar {
        public Server(Path path) {
            super(path, false, false, true, Type.SERVER);
        }

        @Override
        public MinecraftJar forPath(Path path) {
            return new Server(path);
        }
    }

    public static final class Common
    extends MinecraftJar {
        public Common(Path path) {
            super(path, false, false, true, Type.COMMON);
        }

        @Override
        public MinecraftJar forPath(Path path) {
            return new Common(path);
        }
    }

    public static final class Merged
    extends MinecraftJar {
        public Merged(Path path) {
            super(path, true, true, true, Type.MERGED);
        }

        @Override
        public MinecraftJar forPath(Path path) {
            return new Merged(path);
        }
    }
}

