/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.accesswidener.AccessWidener;
import net.fabricmc.accesswidener.AccessWidenerClassVisitor;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.ZipUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AccessWidenerTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessWidenerTransformer.class);
    private final AccessWidener accessWidener;

    AccessWidenerTransformer(AccessWidener accessWidener) {
        this.accessWidener = accessWidener;
    }

    void apply(Path jarFile) {
        try {
            ZipUtils.transform(jarFile, this.getTransformers(this.accessWidener.getTargets()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to apply access wideners to %s".formatted(jarFile), e);
        }
    }

    private List<Pair<String, ZipUtils.UnsafeUnaryOperator<byte[]>>> getTransformers(Set<String> classes) {
        return classes.stream().map(string -> new Pair<CallSite, ZipUtils.UnsafeUnaryOperator<byte[]>>((CallSite)((Object)(string.replaceAll("\\.", "/") + ".class")), this.getTransformer((String)string))).collect(Collectors.toList());
    }

    private ZipUtils.UnsafeUnaryOperator<byte[]> getTransformer(String className) {
        return input -> {
            ClassReader reader = new ClassReader(input);
            ClassWriter writer = new ClassWriter(0);
            ClassVisitor classVisitor = AccessWidenerClassVisitor.createClassVisitor((int)589824, (ClassVisitor)writer, (AccessWidener)this.accessWidener);
            LOGGER.debug("Applying access widener to " + className);
            reader.accept(classVisitor, 0);
            return writer.toByteArray();
        };
    }
}

