/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric;

import dev.architectury.event.events.common.InteractionEvent;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2680;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2344.class)
public abstract class MixinFarmBlock {
    @Unique
    private static ThreadLocal<Triple<Long, Double, class_1297>> turnToDirtLocal = new ThreadLocal<>();
    
    @Inject(
            method = "fallOn",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/FarmBlock;turnToDirt(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"
            )
    )
    private void fallOn(class_1937 level, class_2680 blockState, class_2338 blockPos, class_1297 entity, double d, CallbackInfo ci) {
        turnToDirtLocal.set(Triple.of(blockPos.method_10063(), d, entity));
    }
    
    @Inject(method = "turnToDirt", at = @At("HEAD"), cancellable = true)
    private static void turnToDirt(@Nullable class_1297 entity, class_2680 state, class_1937 level, class_2338 pos, CallbackInfo ci) {
        var triple = turnToDirtLocal.get();
        turnToDirtLocal.remove();
        if (triple != null && triple.getLeft() == pos.method_10063() && triple.getRight() == entity) {
            if (InteractionEvent.FARMLAND_TRAMPLE.invoker().trample(level, pos, state, triple.getMiddle(), entity) != class_1269.field_5811) {
                ci.cancel();
            }
        }
    }
}
