/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.hooks.level.entity.fabric;

import dev.architectury.event.events.common.EntityEvent;
import net.minecraft.class_1297;
import net.minecraft.class_4076;
import net.minecraft.class_5569;

public class EntityHooksImpl {
    public static class_5569 wrapEntityInLevelCallback(class_1297 entity, class_5569 callback) {
        if (callback == class_5569.field_27243) return callback;
        if (callback == null) return callback;
        return new class_5569() {
            private long lastSectionKey = class_4076.method_33706(entity.method_24515());
            
            @Override
            public void method_31749() {
                callback.method_31749();
                var currentSectionKey = class_4076.method_33706(entity.method_24515());
                if (currentSectionKey != lastSectionKey) {
                    EntityEvent.ENTER_SECTION.invoker().enterSection(entity, class_4076.method_18686(lastSectionKey), class_4076.method_18689(lastSectionKey),
                            class_4076.method_18690(lastSectionKey), class_4076.method_18686(currentSectionKey), class_4076.method_18689(currentSectionKey),
                            class_4076.method_18690(currentSectionKey));
                    lastSectionKey = currentSectionKey;
                }
            }
            
            @Override
            public void method_31750(class_1297.class_5529 removalReason) {
                callback.method_31750(removalReason);
            }
        };
    }
}
