/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.hooks.fluid.fabric;

import com.mojang.logging.LogUtils;
import dev.architectury.fluid.FluidStack;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

import java.util.Optional;

public class FluidStackHooksImpl {
    private static final Logger LOGGER = LogUtils.getLogger();
    
    public static class_2561 getName(FluidStack stack) {
        return FluidVariantAttributes.getName(FluidStackHooksFabric.toFabric(stack));
    }
    
    public static String getTranslationKey(FluidStack stack) {
        var id = class_7923.field_41173.method_10221(stack.getFluid());
        return "block." + id.method_12836() + "." + id.method_12832();
    }
    
    public static FluidStack read(class_9129 buf) {
        return FluidStack.STREAM_CODEC.decode(buf);
    }
    
    public static void write(FluidStack stack, class_9129 buf) {
        FluidStack.STREAM_CODEC.encode(buf, stack);
    }
    
    public static Optional<FluidStack> read(class_7225.class_7874 provider, class_2520 tag) {
        return FluidStack.CODEC.parse(provider.method_57093(class_2509.field_11560), tag)
                .resultOrPartial(string -> LOGGER.error("Tried to load invalid fluid stack: '{}'", string));
    }
    
    public static FluidStack readOptional(class_7225.class_7874 provider, class_2487 tag) {
        return tag.method_33133() ? FluidStack.empty() : read(provider, tag).orElse(FluidStack.empty());
    }
    
    public static class_2520 write(class_7225.class_7874 provider, FluidStack stack, class_2520 tag) {
        return FluidStack.CODEC.encode(stack, provider.method_57093(class_2509.field_11560), tag).getOrThrow(IllegalStateException::new);
    }
    
    public static long bucketAmount() {
        return 81000;
    }
    
    public static int getLuminosity(FluidStack fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getLuminance(FluidStackHooksFabric.toFabric(fluid));
    }
    
    public static int getLuminosity(class_3611 fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getLuminance(FluidVariant.of(fluid));
    }
    
    public static int getTemperature(FluidStack fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getTemperature(FluidStackHooksFabric.toFabric(fluid));
    }
    
    public static int getTemperature(class_3611 fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getTemperature(FluidVariant.of(fluid));
    }
    
    public static int getViscosity(FluidStack fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getViscosity(FluidStackHooksFabric.toFabric(fluid), level);
    }
    
    public static int getViscosity(class_3611 fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getViscosity(FluidVariant.of(fluid), level);
    }
}
