/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.hooks.block;

import java.util.Objects;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public class BlockEntityHooks {
    private BlockEntityHooks() {
    }
    
    /**
     * Utility method to sync block entity data to the clients.
     * Original implementation by FabricMC, see copyright notice below.
     *
     * Licensed under the Apache License, Version 2.0 (the "License");
     * you may not use this file except in compliance with the License.
     * You may obtain a copy of the License at
     *
     *     http://www.apache.org/licenses/LICENSE-2.0
     *
     * Unless required by applicable law or agreed to in writing, software
     * distributed under the License is distributed on an "AS IS" BASIS,
     * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     * See the License for the specific language governing permissions and
     * limitations under the License.
     */
    public static void syncData(class_2586 entity) {
        if (!(Objects.requireNonNull(entity.method_10997()) instanceof class_3218 level)) {
            throw new IllegalStateException("Cannot call syncData() on the logical client! Did you check level.isClientSide first?");
        }
        level.method_14178().method_14128(entity.method_11016());
    }
}
