/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.event.events.client;

import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import org.jetbrains.annotations.ApiStatus;

import java.util.List;
import net.minecraft.class_10266;
import net.minecraft.class_10286;
import net.minecraft.class_10298;

public interface ClientRecipeUpdateEvent {
    /**
     * @see ClientRecipeUpdateEvent#update(class_10286)
     */
    Event<ClientRecipeUpdateEvent> EVENT = EventFactory.createLoop();
    
    /**
     * @see ClientRecipeUpdateEvent.Add#add(class_10286, List)
     */
    @ApiStatus.Experimental
    Event<Add> ADD = EventFactory.createLoop();
    
    /**
     * @see ClientRecipeUpdateEvent.Remove#remove(class_10286, List)
     */
    @ApiStatus.Experimental
    Event<Remove> REMOVE = EventFactory.createLoop();
    
    /**
     * Invoked when the client has received an updated list of recipes from the server.
     * Equivalent to Forge's {@code RecipesUpdatedEvent} event.
     *
     * @param recipeAccess The recipe access.
     */
    void update(class_10286 recipeAccess);
    
    @ApiStatus.Experimental
    interface Add {
        void add(class_10286 recipeAccess, List<class_10266.class_10267> entries);
    }
    
    @ApiStatus.Experimental
    interface Remove {
        void remove(class_10286 recipeAccess, List<class_10298> ids);
    }
}
