/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.registry.fabric;

import ;
import com.google.common.primitives.Longs;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import org.apache.commons.lang3.StringUtils;

import java.security.SecureRandom;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class ReloadListenerRegistryImpl {
    private static final SecureRandom RANDOM = new SecureRandom();
    
    public static void register(class_3264 type, class_3302 listener, class_2960 listenerId, Collection<class_2960> dependencies) {
        var bytes = new byte[8];
        RANDOM.nextBytes(bytes);
        var id = listenerId != null ? listenerId : class_2960.method_60654("architectury:reload_" + StringUtils.leftPad(Math.abs(Longs.fromByteArray(bytes)) + "", 19, '0'));
        ResourceManagerHelper.get(type).registerReloadListener(new IdentifiableResourceReloadListener() {
            @Override
            public class_2960 getFabricId() {
                return id;
            }
            
            @Override
            public String method_22322() {
                return listener.method_22322();
            }
            
            @Override
            public Collection<class_2960> getFabricDependencies() {
                return dependencies;
            }
            
            @Override
            public CompletableFuture<Void> method_25931(class_11558 sharedState, Executor executor, class_4045 preparationBarrier, Executor executor2) {
                return listener.method_25931(sharedState, executor, preparationBarrier, executor2);
            }
        });
    }
}
