/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.networking;

import dev.architectury.extensions.network.EntitySpawnExtension;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2960;
import net.minecraft.class_3231;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

/**
 * @see net.minecraft.class_2604
 */
public class SpawnEntityPacket {
    static final class_2960 PACKET_ID = class_2960.method_60655("architectury", "spawn_entity_packet");
    static final class_8710.class_9154<PacketPayload> PACKET_TYPE = new class_8710.class_9154<>(PACKET_ID);
    static final class_9139<class_9129, PacketPayload> PACKET_CODEC = class_8710.method_56484(PacketPayload::write, PacketPayload::new);
    
    public static class_2596<class_2602> create(class_1297 entity, class_3231 serverEntity) {
        if (entity.method_73183().method_8608()) {
            throw new IllegalStateException("SpawnPacketUtil.create called on the logical client!");
        }
        return (class_2596<class_2602>) NetworkManager.toPacket(NetworkManager.s2c(), new PacketPayload(entity, serverEntity), entity.method_56673());
    }
    
    public static void register() {
        NetworkManager.registerS2CPayloadType(PACKET_TYPE, PACKET_CODEC);
    }
    
    record PacketPayload(class_1299<?> entityType, UUID uuid, int id, double x, double y, double z, float xRot,
                                 float yRot,
                                 float yHeadRot,
                                 double deltaX, double deltaY, double deltaZ,
                                 byte[] data) implements class_8710 {
        public PacketPayload(class_9129 buf) {
            this(class_9135.method_56365(class_7924.field_41266).decode(buf), buf.method_10790(), buf.method_10816(), buf.readDouble(), buf.readDouble(), buf.readDouble(),
                    buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readDouble(), buf.readDouble(), buf.readDouble(),
                    buf.method_10795());
        }
        
        public PacketPayload(class_1297 entity, class_3231 serverEntity) {
            this(entity.method_5864(), entity.method_5667(), entity.method_5628(), serverEntity.method_60942().method_10216(),
                    serverEntity.method_60942().method_10214(), serverEntity.method_60942().method_10215(), serverEntity.method_60944(),
                    serverEntity.method_60945(), serverEntity.method_60946(), serverEntity.method_60943().field_1352,
                    serverEntity.method_60943().field_1351, serverEntity.method_60943().field_1350, saveExtra(entity));
        }
        
        public PacketPayload(class_1297 entity, class_2338 pos) {
            this(entity.method_5864(), entity.method_5667(), entity.method_5628(), pos.method_10263(),
                    pos.method_10264(), pos.method_10260(), entity.method_36455(), entity.method_36454(), entity.method_5791(),
                    entity.method_18798().field_1352, entity.method_18798().field_1351, entity.method_18798().field_1350, saveExtra(entity));
        }
        
        private static byte[] saveExtra(class_1297 entity) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            try {
                if (entity instanceof EntitySpawnExtension ext) {
                    ext.saveAdditionalSpawnData(buf);
                }
                return ByteBufUtil.getBytes(buf);
            } finally {
                buf.release();
            }
        }
        
        public void write(class_9129 buf) {
            class_9135.method_56365(class_7924.field_41266).encode(buf, entityType);
            buf.method_10797(uuid);
            buf.method_10804(id);
            buf.method_52940(x);
            buf.method_52940(y);
            buf.method_52940(z);
            buf.method_52941(xRot);
            buf.method_52941(yRot);
            buf.method_52941(yHeadRot);
            buf.method_52940(deltaX);
            buf.method_52940(deltaY);
            buf.method_52940(deltaZ);
            buf.method_10813(data);
        }
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_TYPE;
        }
    }
}
