/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric.client;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.common.EntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.logging.Level;
import net.minecraft.class_1297;
import net.minecraft.class_2874;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_761;

@Mixin(class_638.class)
public class MixinClientLevel {
    @Inject(method = "<init>", at = @At("RETURN"))
    private void construct(class_634 clientPacketListener, class_638.class_5271 clientLevelData, class_5321<Level> resourceKey, class_6880<class_2874> holder, int i, int j, class_761 levelRenderer, boolean bl, long l, int k, CallbackInfo ci) {
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.invoker().act((class_638) (Object) this);
    }
    
    @Inject(method = "addEntity", at = @At("HEAD"), cancellable = true)
    private void addEntity(class_1297 entity, CallbackInfo ci) {
        if (EntityEvent.ADD.invoker().add(entity, (class_638) (Object) this).isFalse()) {
            ci.cancel();
        }
    }
}
