/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric;

import com.llamalad7.mixinextras.sugar.Local;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.hooks.fabric.PersistentEntitySectionManagerHooks;
import net.minecraft.class_11749;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3536;
import net.minecraft.class_5362;
import net.minecraft.class_5579;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.class_9892;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3218.class)
public class MixinServerLevel {
    @Shadow
    @Final
    private class_5579<class_1297> entityManager;
    
    @Inject(method = "save", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/level/ServerChunkCache;save(Z)V"))
    private void save(class_3536 progressListener, boolean bl, boolean bl2, CallbackInfo ci) {
        LifecycleEvent.SERVER_LEVEL_SAVE.invoker().act((class_3218) (Object) this);
    }
    
    @Inject(method = "addEntity", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;addNewEntity(Lnet/minecraft/world/level/entity/EntityAccess;)Z"),
            cancellable = true)
    private void addEntity(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        ((PersistentEntitySectionManagerHooks) this.entityManager).architectury_attachLevel((class_3218) (Object) this);
    }
    
    @Inject(method = "explode",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/ServerExplosion;explode()I"), cancellable = true)
    private void explodePre(class_1297 entity, class_1282 damageSource, class_5362 explosionDamageCalculator, double d, double e, double f, float g, boolean bl, class_1937.class_7867 explosionInteraction, class_2394 particleOptions, class_2394 particleOptions2, class_6012<class_11749> weightedList, class_6880<class_3414> holder, CallbackInfo ci, @Local class_9892 explosion) {
        if (ExplosionEvent.PRE.invoker().explode((class_1937) (Object) this, explosion).isFalse()) {
            ci.cancel();
        }
    }
}
