/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import net.minecraft.class_1308;
import net.minecraft.class_1917;
import net.minecraft.class_1936;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_1917.class)
public abstract class MixinBaseSpawner {
    @Redirect(
            method = "serverTick",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/Mob;checkSpawnRules(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/world/entity/EntitySpawnReason;)Z",
                    ordinal = 0
            )
    )
    private boolean checkSpawnerSpawn(class_1308 mob, class_1936 level, class_3730 reason) {
        var result = EntityEvent.LIVING_CHECK_SPAWN.invoker()
                .canSpawn(mob, level, mob.method_23317(), mob.method_23318(), mob.method_23321(), reason, (class_1917) (Object) this);
        if (result.value() != null) {
            return result.value();
        }
        return mob.method_5979(level, reason) && mob.method_5957(level);
    }
    
    @Redirect(
            method = "serverTick",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/Mob;checkSpawnObstruction(Lnet/minecraft/world/level/LevelReader;)Z",
                    ordinal = 0
            )
    )
    private boolean skipDoubleObstruction(class_1308 mob, class_4538 levelReader) {
        return true;
    }
}
