/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking.transformers;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.PacketTransformer;
import dev.architectury.networking.transformers.client.ClientSplitPacketTransformer;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class SplitPacketTransformer
implements PacketTransformer {
    private static final Logger LOGGER = LogManager.getLogger(SplitPacketTransformer.class);
    private static final byte START = 0;
    private static final byte PART = 1;
    private static final byte END = 2;
    private static final byte ONLY = 3;
    private final Map<PartKey, PartData> cache = Collections.synchronizedMap(new HashMap());

    public SplitPacketTransformer() {
        PlayerEvent.PLAYER_QUIT.register(player -> this.cache.keySet().removeIf(key -> Objects.equals(key.playerUUID, player.method_5667())));
        EnvExecutor.runInEnv(Env.CLIENT, () -> () -> ClientSplitPacketTransformer.init(this.cache));
    }

    @Override
    public void inbound(NetworkManager.Side side, class_2960 id, class_9129 buf, NetworkManager.PacketContext context, PacketTransformer.TransformationSink sink) {
        PartKey key = side == NetworkManager.Side.S2C ? new PartKey(side, null) : new PartKey(side, context.getPlayer().method_5667());
        switch (buf.readByte()) {
            case 0: {
                PartData data = new PartData(id, buf.readInt());
                if (this.cache.put(key, data) != null) {
                    LOGGER.warn("Received invalid START packet for SplitPacketTransformer with packet id " + String.valueOf(id) + " for side " + String.valueOf((Object)side));
                }
                buf.method_52938();
                data.parts.add(buf);
                break;
            }
            case 1: {
                PartData data = this.cache.get(key);
                if (data == null) {
                    LOGGER.warn("Received invalid PART packet for SplitPacketTransformer with packet id " + String.valueOf(id) + " for side " + String.valueOf((Object)side));
                    buf.release();
                    break;
                }
                if (!data.id.equals((Object)id)) {
                    LOGGER.warn("Received invalid PART packet for SplitPacketTransformer with packet id " + String.valueOf(id) + " for side " + String.valueOf((Object)side) + ", id in cache is " + String.valueOf(data.id));
                    buf.release();
                    for (class_9129 part : data.parts) {
                        if (part == buf) continue;
                        part.release();
                    }
                    this.cache.remove(key);
                    break;
                }
                buf.method_52938();
                data.parts.add(buf);
                break;
            }
            case 2: {
                PartData data = this.cache.get(key);
                if (data == null) {
                    LOGGER.warn("Received invalid END packet for SplitPacketTransformer with packet id " + String.valueOf(id) + " for side " + String.valueOf((Object)side));
                    buf.release();
                } else if (!data.id.equals((Object)id)) {
                    LOGGER.warn("Received invalid END packet for SplitPacketTransformer with packet id " + String.valueOf(id) + " for side " + String.valueOf((Object)side) + ", id in cache is " + String.valueOf(data.id));
                    buf.release();
                    for (class_9129 part : data.parts) {
                        if (part == buf) continue;
                        part.release();
                    }
                    this.cache.remove(key);
                } else {
                    buf.method_52938();
                    data.parts.add(buf);
                }
                if (data.parts.size() != data.partsExpected) {
                    LOGGER.warn("Received invalid END packet for SplitPacketTransformer with packet id " + String.valueOf(id) + " for side " + String.valueOf((Object)side) + " with size " + String.valueOf(data.parts) + ", parts expected is " + data.partsExpected);
                    for (class_9129 part : data.parts) {
                        if (part == buf) continue;
                        part.release();
                    }
                } else {
                    class_9129 byteBuf = new class_9129(Unpooled.wrappedBuffer((ByteBuf[])data.parts.toArray(new ByteBuf[0])), buf.method_56349());
                    sink.accept(side, data.id, byteBuf);
                    byteBuf.release();
                }
                this.cache.remove(key);
                break;
            }
            case 3: {
                sink.accept(side, id, buf);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal split packet header!");
            }
        }
    }

    @Override
    public void outbound(NetworkManager.Side side, class_2960 id, class_9129 buf, PacketTransformer.TransformationSink sink) {
        int maxSize = (side == NetworkManager.Side.C2S ? Short.MAX_VALUE : 0x100000) - 1 - 20 - id.toString().getBytes(StandardCharsets.UTF_8).length;
        if (buf.readableBytes() <= maxSize) {
            ByteBuf stateBuf = Unpooled.buffer((int)1);
            stateBuf.writeByte(3);
            class_9129 packetBuffer = new class_9129(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{stateBuf, buf}), buf.method_56349());
            sink.accept(side, id, packetBuffer);
        } else {
            int partSize = maxSize - 4;
            int parts = (int)Math.ceil((float)buf.readableBytes() / (float)partSize);
            for (int i = 0; i < parts; ++i) {
                class_9129 packetBuffer = new class_9129(Unpooled.buffer(), buf.method_56349());
                if (i == 0) {
                    packetBuffer.method_52997(0);
                    packetBuffer.method_53002(parts);
                } else if (i == parts - 1) {
                    packetBuffer.method_52997(2);
                } else {
                    packetBuffer.method_52997(1);
                }
                int next = Math.min(buf.readableBytes(), partSize);
                packetBuffer.method_52975(buf.retainedSlice(buf.readerIndex(), next));
                buf.method_52994(next);
                sink.accept(side, id, packetBuffer);
            }
            buf.release();
        }
    }

    @ApiStatus.Internal
    public record PartKey(NetworkManager.Side side, @Nullable UUID playerUUID) {
    }

    public record PartData(class_2960 id, int partsExpected, List<class_9129> parts) {
        private PartData(class_2960 id, int partsExpected) {
            this(id, partsExpected, new ArrayList<class_9129>());
        }
    }
}

