/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.hooks.fluid.fabric;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FluidStackHooksImpl {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static class_2561 getName(FluidStack stack) {
        return FluidVariantAttributes.getName((FluidVariant)FluidStackHooksFabric.toFabric(stack));
    }

    public static String getTranslationKey(FluidStack stack) {
        class_2960 id = class_7923.field_41173.method_10221((Object)stack.getFluid());
        return "block." + id.method_12836() + "." + id.method_12832();
    }

    public static FluidStack read(class_9129 buf) {
        return (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buf);
    }

    public static void write(FluidStack stack, class_9129 buf) {
        FluidStack.STREAM_CODEC.encode((Object)buf, (Object)stack);
    }

    public static Optional<FluidStack> read(class_7225.class_7874 provider, class_2520 tag) {
        return FluidStack.CODEC.parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).resultOrPartial(string -> LOGGER.error("Tried to load invalid fluid stack: '{}'", string));
    }

    public static FluidStack readOptional(class_7225.class_7874 provider, class_2487 tag) {
        return tag.method_33133() ? FluidStack.empty() : FluidStackHooksImpl.read(provider, (class_2520)tag).orElse(FluidStack.empty());
    }

    public static class_2520 write(class_7225.class_7874 provider, FluidStack stack, class_2520 tag) {
        return (class_2520)FluidStack.CODEC.encode((Object)stack, (DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).getOrThrow(IllegalStateException::new);
    }

    public static long bucketAmount() {
        return 81000L;
    }

    public static int getLuminosity(FluidStack fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getLuminance((FluidVariant)FluidStackHooksFabric.toFabric(fluid));
    }

    public static int getLuminosity(class_3611 fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getLuminance((FluidVariant)FluidVariant.of((class_3611)fluid));
    }

    public static int getTemperature(FluidStack fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getTemperature((FluidVariant)FluidStackHooksFabric.toFabric(fluid));
    }

    public static int getTemperature(class_3611 fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getTemperature((FluidVariant)FluidVariant.of((class_3611)fluid));
    }

    public static int getViscosity(FluidStack fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getViscosity((FluidVariant)FluidStackHooksFabric.toFabric(fluid), (class_1937)level);
    }

    public static int getViscosity(class_3611 fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getViscosity((FluidVariant)FluidVariant.of((class_3611)fluid), (class_1937)level);
    }
}

