/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.registry.client.particle.fabric;

import dev.architectury.registry.client.particle.ParticleProviderRegistry;
import net.fabricmc.fabric.api.client.particle.v1.FabricSpriteProvider;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_5819;
import net.minecraft.class_707;
import java.util.List;

public class ParticleProviderRegistryImpl {
    public record ExtendedSpriteSetImpl(
            FabricSpriteProvider delegate
    ) implements ParticleProviderRegistry.ExtendedSpriteSet {
        @Override
        public class_1059 getAtlas() {
            return delegate.getAtlas();
        }
        
        @Override
        public List<class_1058> getSprites() {
            return delegate.getSprites();
        }
        
        @Override
        public class_1058 method_18138(int i, int j) {
            return delegate.method_18138(i, j);
        }
        
        @Override
        public class_1058 method_18139(class_5819 random) {
            return delegate.method_18139(random);
        }
        
        @Override
        public class_1058 method_74304() {
            return delegate.method_74304();
        }
    }
    
    public static <T extends class_2394> void register(class_2396<T> type, class_707<T> provider) {
        ParticleFactoryRegistry.getInstance().register(type, provider);
    }
    
    public static <T extends class_2394> void register(class_2396<T> type, ParticleProviderRegistry.DeferredParticleProvider<T> provider) {
        ParticleFactoryRegistry.getInstance().register(type, sprites ->
                provider.create(new ExtendedSpriteSetImpl(sprites)));
    }
}
